/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class VcsLogContentUtil {
    private static final Logger LOG = Logger.getInstance(VcsLogContentUtil.class);

    public static <U extends AbstractVcsLogUi> boolean findAndSelectContent(@NotNull Project project2, @NotNull Class<U> clazz, @NotNull Condition<U> condition2) {
        ToolWindow toolWindow;
        ContentManager manager;
        JComponent component;
        if (project2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            VcsLogContentUtil.$$$reportNull$$$0(1);
        }
        if (condition2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(2);
        }
        if ((component = ContentUtilEx.findContentComponent(manager = (toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS)).getContentManager(), (Condition<JComponent>)((Condition)c -> {
            if (clazz == null) {
                VcsLogContentUtil.$$$reportNull$$$0(23);
            }
            if (condition2 == null) {
                VcsLogContentUtil.$$$reportNull$$$0(24);
            }
            VcsLogPanel vcsLogPanel = null;
            if (c instanceof VcsLogPanel) {
                vcsLogPanel = (VcsLogPanel)((Object)((Object)c));
            } else if (c instanceof JPanel) {
                vcsLogPanel = (VcsLogPanel)((Object)((Object)ContainerUtil.findInstance((Object[])c.getComponents(), VcsLogPanel.class)));
            }
            if (vcsLogPanel != null) {
                AbstractVcsLogUi ui = vcsLogPanel.getUi();
                return clazz.isInstance(ui) && condition2.value((Object)ui);
            }
            return false;
        }))) == null) {
            return false;
        }
        if (!toolWindow.isVisible()) {
            toolWindow.activate(null);
        }
        return ContentUtilEx.selectContent(manager, component, true);
    }

    public static boolean selectLogUi(@NotNull Project project2, @NotNull VcsLogUi ui) {
        if (project2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(3);
        }
        if (ui == null) {
            VcsLogContentUtil.$$$reportNull$$$0(4);
        }
        return VcsLogContentUtil.findAndSelectContent(project2, AbstractVcsLogUi.class, u -> {
            if (ui == null) {
                VcsLogContentUtil.$$$reportNull$$$0(22);
            }
            return u.equals(ui);
        });
    }

    public static void openAnotherLogTab(@NotNull VcsLogManager logManager, @NotNull Project project2) {
        if (logManager == null) {
            VcsLogContentUtil.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(6);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        String name2 = VcsLogContentUtil.generateShortName(toolWindow);
        VcsLogContentUtil.openLogTab(project2, logManager, "Log", name2, logManager.getMainLogUiFactory(name2));
    }

    @NotNull
    private static String generateShortName(@NotNull ToolWindow toolWindow) {
        TabbedContent tabbedContent;
        if (toolWindow == null) {
            VcsLogContentUtil.$$$reportNull$$$0(7);
        }
        if ((tabbedContent = ContentUtilEx.findTabbedContent(toolWindow.getContentManager(), "Log")) != null) {
            String string = String.valueOf(tabbedContent.getTabs().size() + 1);
            if (string == null) {
                VcsLogContentUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        List contents = ContainerUtil.filter((Object[])toolWindow.getContentManager().getContents(), content -> "Log".equals(content.getUserData(Content.TAB_GROUP_NAME_KEY)));
        String string = String.valueOf(contents.size() + 1);
        if (string == null) {
            VcsLogContentUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static <U extends AbstractVcsLogUi> void openLogTab(@NotNull Project project2, @NotNull VcsLogManager logManager, @NotNull String tabGroupName, @NotNull String shortName, @NotNull VcsLogManager.VcsLogUiFactory<U> factory) {
        if (project2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(10);
        }
        if (logManager == null) {
            VcsLogContentUtil.$$$reportNull$$$0(11);
        }
        if (tabGroupName == null) {
            VcsLogContentUtil.$$$reportNull$$$0(12);
        }
        if (shortName == null) {
            VcsLogContentUtil.$$$reportNull$$$0(13);
        }
        if (factory == null) {
            VcsLogContentUtil.$$$reportNull$$$0(14);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        String name2 = ContentUtilEx.getFullName(tabGroupName, shortName);
        U logUi = logManager.createLogUi(name2, factory);
        ContentUtilEx.addTabbedContent(toolWindow.getContentManager(), (JComponent)((Object)new VcsLogPanel(logManager, (AbstractVcsLogUi)logUi)), tabGroupName, shortName, true, logUi);
        toolWindow.activate(null);
        logManager.scheduleInitialization();
    }

    public static void openMainLogAndExecute(@NotNull Project project2, @NotNull Consumer<VcsLogUiImpl> consumer) {
        ToolWindow window;
        if (project2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            VcsLogContentUtil.$$$reportNull$$$0(16);
        }
        if (!VcsLogContentUtil.selectMainLog(window = ToolWindowManager.getInstance((Project)project2).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID))) {
            VcsBalloonProblemNotifier.showOverChangesView(project2, "Vcs Log is not available", MessageType.WARNING, new NamedRunnable[0]);
            return;
        }
        Runnable runConsumer = () -> {
            if (project2 == null) {
                VcsLogContentUtil.$$$reportNull$$$0(20);
            }
            if (consumer == null) {
                VcsLogContentUtil.$$$reportNull$$$0(21);
            }
            ((VcsLogContentProvider)ObjectUtils.notNull((Object)VcsLogContentProvider.getInstance(project2))).executeOnMainUiCreated(consumer);
        };
        if (!window.isVisible()) {
            window.activate(runConsumer);
        } else {
            runConsumer.run();
        }
    }

    private static boolean selectMainLog(@NotNull ToolWindow window) {
        Content[] contents;
        if (window == null) {
            VcsLogContentUtil.$$$reportNull$$$0(17);
        }
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    public static void closeLogTabs(@NotNull ToolWindow toolWindow, @NotNull Collection<String> tabs) {
        if (toolWindow == null) {
            VcsLogContentUtil.$$$reportNull$$$0(18);
        }
        if (tabs == null) {
            VcsLogContentUtil.$$$reportNull$$$0(19);
        }
        for (String tabName : tabs) {
            boolean closed = ContentUtilEx.closeContentTab(toolWindow.getContentManager(), tabName);
            LOG.assertTrue(closed, (Object)("Could not find content component for tab " + tabName + "\nExisting content: " + Arrays.toString(toolWindow.getContentManager().getContents()) + "\nTabs to close: " + tabs));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogContentUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabGroupName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectContent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectLogUi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openAnotherLogTab";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateShortName";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openMainLogAndExecute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectMainLog";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "closeLogTabs";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openMainLogAndExecute$3";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectLogUi$1";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findAndSelectContent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

