/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsWatcher
implements Disposable {
    private static final String TOOLWINDOW_ID = ChangesViewContentManager.TOOLWINDOW_ID;
    @NotNull
    private final PostponableLogRefresher myRefresher;
    @NotNull
    private final ToolWindowManagerEx myToolWindowManager;
    @NotNull
    private final MyRefreshPostponedEventsListener myPostponedEventsListener;
    @Nullable
    private ToolWindow myToolWindow;
    private boolean myIsVisible;

    public VcsLogTabsWatcher(@NotNull Project project2, @NotNull PostponableLogRefresher refresher) {
        if (project2 == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(0);
        }
        if (refresher == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(1);
        }
        this.myRefresher = refresher;
        this.myToolWindowManager = ToolWindowManagerEx.getInstanceEx(project2);
        this.myPostponedEventsListener = new MyRefreshPostponedEventsListener();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myToolWindowManager.addToolWindowManagerListener(this.myPostponedEventsListener);
            this.installContentListener();
        });
    }

    @Nullable
    private String getSelectedTabName() {
        Content content;
        if (this.myToolWindow != null && this.myToolWindow.isVisible() && (content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            return content.getTabName();
        }
        return null;
    }

    @NotNull
    public Disposable addTabToWatch(@NotNull String contentTabName, @NotNull VisiblePackRefresher refresher) {
        if (contentTabName == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(3);
        }
        Disposable disposable = this.myRefresher.addLogWindow(new VcsLogTab(refresher, contentTabName));
        if (disposable == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(4);
        }
        return disposable;
    }

    private void installContentListener() {
        ToolWindow window = this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (window != null) {
            this.myToolWindow = window;
            this.myIsVisible = this.myToolWindow.isVisible();
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
        }
    }

    private void removeListeners() {
        this.myToolWindowManager.removeToolWindowManagerListener(this.myPostponedEventsListener);
        if (this.myToolWindow != null) {
            this.myToolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            for (Content content : this.myToolWindow.getContentManager().getContents()) {
                if (!(content instanceof TabbedContent)) continue;
                content.removePropertyChangeListener((PropertyChangeListener)this.myPostponedEventsListener);
            }
        }
    }

    public void closeLogTabs() {
        if (this.myToolWindow != null) {
            VcsLogContentUtil.closeLogTabs(this.myToolWindow, ((StreamEx)StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogTab.class).map(VcsLogTab::getTabName).filter(name2 -> !"Log".equals(name2))).toList());
        }
    }

    public void dispose() {
        this.removeListeners();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTabName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addTabToWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTabToWatch";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRefreshPostponedEventsListener
    extends ContentManagerAdapter
    implements ToolWindowManagerListener,
    PropertyChangeListener {
        private MyRefreshPostponedEventsListener() {
        }

        private void selectionChanged() {
            String tabName = VcsLogTabsWatcher.this.getSelectedTabName();
            if (tabName != null) {
                this.selectionChanged(tabName);
            }
        }

        private void selectionChanged(String tabName) {
            PostponableLogRefresher.VcsLogWindow logWindow = (PostponableLogRefresher.VcsLogWindow)ContainerUtil.find(VcsLogTabsWatcher.this.myRefresher.getLogWindows(), window -> window instanceof VcsLogTab && ((VcsLogTab)window).myTabName.equals(tabName));
            if (logWindow != null) {
                VcsLogTabsWatcher.this.myRefresher.filtererActivated(logWindow.getRefresher(), false);
            }
        }

        public void selectionChanged(ContentManagerEvent event) {
            if (ContentManagerEvent.ContentOperation.add.equals((Object)event.getOperation())) {
                this.selectionChanged(event.getContent().getTabName());
            }
        }

        public void contentAdded(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void stateChanged() {
            if (VcsLogTabsWatcher.this.myToolWindow == null) {
                return;
            }
            if (VcsLogTabsWatcher.this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID) == null) {
                VcsLogTabsWatcher.this.removeListeners();
            } else if (VcsLogTabsWatcher.this.myIsVisible != VcsLogTabsWatcher.this.myToolWindow.isVisible()) {
                VcsLogTabsWatcher.this.myIsVisible = VcsLogTabsWatcher.this.myToolWindow.isVisible();
                this.selectionChanged();
            }
        }

        @Override
        public void toolWindowRegistered(@NotNull String id) {
            if (id == null) {
                MyRefreshPostponedEventsListener.$$$reportNull$$$0(0);
            }
            if (id.equals(TOOLWINDOW_ID)) {
                VcsLogTabsWatcher.this.installContentListener();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("component")) {
                this.selectionChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/impl/VcsLogTabsWatcher$MyRefreshPostponedEventsListener", "toolWindowRegistered"));
        }
    }

    public class VcsLogTab
    extends PostponableLogRefresher.VcsLogWindow {
        @NotNull
        private final String myTabName;

        public VcsLogTab(@NotNull VisiblePackRefresher refresher, String tabName) {
            if (refresher == null) {
                VcsLogTab.$$$reportNull$$$0(0);
            }
            if (tabName == null) {
                VcsLogTab.$$$reportNull$$$0(1);
            }
            super(refresher);
            this.myTabName = tabName;
        }

        @Override
        public boolean isVisible() {
            String selectedTab = VcsLogTabsWatcher.this.getSelectedTabName();
            return selectedTab != null && this.myTabName.equals(selectedTab);
        }

        @NotNull
        public String getTabName() {
            String string = this.myTabName;
            if (string == null) {
                VcsLogTab.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refresher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTab";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTab";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

