/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    private static final Logger LOG = Logger.getInstance(VcsLogUserFilterImpl.class);
    @NotNull
    public static final String ME = "me";
    @NotNull
    private final Collection<String> myUsers;
    @NotNull
    private final Map<VirtualFile, VcsUser> myData;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByNames;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByEmails;

    public VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData, @NotNull Set<VcsUser> allUsers) {
        if (users == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(0);
        }
        if (meData == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(1);
        }
        if (allUsers == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(2);
        }
        this.myAllUsersByNames = MultiMap.create();
        this.myAllUsersByEmails = MultiMap.create();
        this.myUsers = users;
        this.myData = meData;
        for (VcsUser user : allUsers) {
            String email;
            String nameFromEmail;
            String name2 = user.getName();
            if (!name2.isEmpty()) {
                this.myAllUsersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm(name2), (Object)user);
            }
            if ((nameFromEmail = VcsUserUtil.getNameFromEmail(email = user.getEmail())) == null) continue;
            this.myAllUsersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm(nameFromEmail), (Object)user);
        }
    }

    @NotNull
    public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(3);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (String user : this.myUsers) {
            result2.addAll(this.getUsers(root, user));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsUser> getUsers(@NotNull VirtualFile root, @NotNull String name2) {
        if (root == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(6);
        }
        HashSet users = ContainerUtil.newHashSet();
        if (ME.equals(name2)) {
            VcsUser vcsUser = this.myData.get(root);
            if (vcsUser != null) {
                users.addAll(this.getUsers(vcsUser.getName()));
                String emailNamePart = VcsUserUtil.getNameFromEmail(vcsUser.getEmail());
                if (emailNamePart != null) {
                    users.addAll(this.getUsers(emailNamePart));
                }
            }
        } else {
            users.addAll(this.getUsers(name2));
        }
        HashSet hashSet = users;
        if (hashSet == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getUserNamesForPresentation() {
        Collection<String> collection = this.myUsers;
        if (collection == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    public boolean matches(@NotNull VcsCommitMetadata commit) {
        if (commit == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists(this.myUsers, name2 -> {
            Set<VcsUser> users;
            if (commit == null) {
                VcsLogUserFilterImpl.$$$reportNull$$$0(11);
            }
            if (!(users = this.getUsers(commit.getRoot(), (String)name2)).isEmpty()) {
                return users.contains(commit.getAuthor());
            }
            if (!name2.equals(ME)) {
                boolean result2;
                String lowerUser = VcsUserUtil.nameToLowerCase(name2);
                boolean bl = result2 = VcsUserUtil.nameToLowerCase(commit.getAuthor().getName()).equals(lowerUser) || VcsUserUtil.emailToLowerCase(commit.getAuthor().getEmail()).startsWith(lowerUser + "@");
                if (result2) {
                    LOG.warn("Unregistered author " + commit.getAuthor() + " for commit " + ((Hash)commit.getId()).asString() + "; search pattern " + name2);
                }
                return result2;
            }
            return false;
        });
    }

    private Set<VcsUser> getUsers(@NotNull String name2) {
        if (name2 == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(10);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        result2.addAll(this.myAllUsersByNames.get((Object)VcsUserUtil.getNameInStandardForm(name2)));
        result2.addAll(this.myAllUsersByEmails.get((Object)VcsUserUtil.getNameInStandardForm(name2)));
        return result2;
    }

    public String toString() {
        return "author: " + StringUtil.join(this.myUsers, (String)", ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allUsers";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogUserFilterImpl";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogUserFilterImpl";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserNamesForPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUsers";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$matches$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

