/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final LazyVcsLogManager myLogManager;
    private int myRecreatedLogCount;

    public VcsProjectLog(@NotNull Project project2, @NotNull MessageBus messageBus, @NotNull VcsLogTabsProperties uiProperties) {
        if (project2 == null) {
            VcsProjectLog.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            VcsProjectLog.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsProjectLog.$$$reportNull$$$0(2);
        }
        this.myLogManager = new LazyVcsLogManager();
        this.myRecreatedLogCount = 0;
        this.myProject = project2;
        this.myMessageBus = messageBus;
        this.myUiProperties = uiProperties;
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @NotNull
    private Collection<VcsRoot> getVcsRoots() {
        List<VcsRoot> list2 = Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcsRoots());
        if (list2 == null) {
            VcsProjectLog.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        VcsLogContentProvider logContentProvider = VcsLogContentProvider.getInstance(this.myProject);
        if (logContentProvider == null) {
            return null;
        }
        return logContentProvider.getUi();
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    private void recreateLog() {
        UIUtil.invokeLaterIfNeeded(() -> this.myLogManager.drop(() -> {
            if (this.hasDvcsRoots()) {
                this.createLog(false);
            }
        }));
    }

    private void recreateOnError(@NotNull Throwable t) {
        if (t == null) {
            VcsProjectLog.$$$reportNull$$$0(4);
        }
        if (++this.myRecreatedLogCount % 5 == 0) {
            String message2 = String.format("VCS Log was recreated %d times due to data corruption\nDelete %s directory and restart %s if this happens often.\n%s", this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName(), t.getMessage());
            LOG.error(message2, t);
            VcsLogManager manager = this.getLogManager();
            if (manager != null && manager.isLogVisible()) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message2, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug("Recreating VCS Log after storage corruption", t);
        }
        this.recreateLog();
    }

    public void createLog(boolean forceInit) {
        VcsLogManager logManager = this.myLogManager.getValue();
        ApplicationManager.getApplication().invokeLater(() -> {
            VcsLogCachesInvalidator invalidator;
            if (logManager.isLogVisible() || forceInit) {
                logManager.scheduleInitialization();
            } else if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class)))).isValid()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
            }
        });
    }

    private boolean hasDvcsRoots() {
        return !VcsLogManager.findLogProviders(this.getVcsRoots(), this.myProject).isEmpty();
    }

    public static VcsProjectLog getInstance(@NotNull Project project2) {
        if (project2 == null) {
            VcsProjectLog.$$$reportNull$$$0(5);
        }
        return (VcsProjectLog)ServiceManager.getService((Project)project2, VcsProjectLog.class);
    }

    public void dispose() {
        this.myLogManager.drop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recreateOnError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectLogListener {
        public void logCreated(@NotNull VcsLogManager var1);

        public void logDisposed(@NotNull VcsLogManager var1);
    }

    public static class InitLogStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                InitLogStartupActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (project2 == null) {
                    InitLogStartupActivity.$$$reportNull$$$0(1);
                }
                VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
                MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
                connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> projectLog.recreateLog());
                if (projectLog.hasDvcsRoots()) {
                    projectLog.createLog(false);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog$InitLogStartupActivity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$runActivity$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        public synchronized VcsLogManager getValue() {
            if (this.myValue == null) {
                VcsLogManager value2;
                this.myValue = value2 = this.compute();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!VcsProjectLog.this.myProject.isDisposed()) {
                        ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated(value2);
                    }
                });
            }
            VcsLogManager vcsLogManager = this.myValue;
            if (vcsLogManager == null) {
                LazyVcsLogManager.$$$reportNull$$$0(0);
            }
            return vcsLogManager;
        }

        @NotNull
        protected synchronized VcsLogManager compute() {
            VcsLogManager vcsLogManager = new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, VcsProjectLog.this.getVcsRoots(), false, (Consumer<Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError(x$0)));
            if (vcsLogManager == null) {
                LazyVcsLogManager.$$$reportNull$$$0(1);
            }
            return vcsLogManager;
        }

        public synchronized void drop() {
            LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
            this.drop(null);
        }

        public synchronized void drop(@Nullable Runnable callback) {
            if (this.myValue != null) {
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed(this.myValue);
                this.myValue.dispose(callback);
            }
            this.myValue = null;
        }

        @Nullable
        public synchronized VcsLogManager getCached() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

