/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcsUtil.VcsUtil;
import icons.VcsLogIcons;
import org.jetbrains.annotations.NotNull;

public class ShowOtherBranchesAction
extends BooleanPropertyToggleAction {
    public ShowOtherBranchesAction() {
        super("Show All Branches", "Switch between showing only current branch and all branches", VcsLogIcons.ShowOtherBranches);
    }

    @Override
    protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
        return FileHistoryUiProperties.SHOW_ALL_BRANCHES;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowOtherBranchesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project2 = e.getProject();
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        if (project2 != null && logManager != null && filePath != null) {
            VcsLogIndex index = logManager.getDataManager().getIndex();
            VirtualFile root = VcsUtil.getVcsRootFor((Project)project2, (FilePath)filePath);
            if (root != null && !index.isIndexed(root)) {
                e.getPresentation().setEnabled(false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/ShowOtherBranchesAction", "update"));
    }
}

