/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    public static final int TOP_TEXT_PADDING = JBUI.scale((int)1);
    public static final int BOTTOM_TEXT_PADDING = JBUI.scale((int)2);
    public static final int RIGHT_PADDING = JBUI.scale((int)4);
    public static final int LEFT_PADDING = JBUI.scale((int)2);
    public static final int COMPACT_MIDDLE_PADDING = JBUI.scale((int)2);
    public static final int MIDDLE_PADDING = JBUI.scale((int)12);
    private static final int MAX_LENGTH = 22;
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    private static final JBColor BACKGROUND = new JBColor(Color.BLACK, Color.WHITE);
    private static final float BALANCE = 0.08f;
    private static final JBColor TEXT_COLOR = new JBColor(new Color(0x7A7A7A), new Color(0x909090));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private List<Pair<String, LabelIcon>> myLabels;
    private int myHeight;
    private int myWidth;
    @NotNull
    private Color myBackground;
    @Nullable
    private Color myGreyBackground;
    @NotNull
    private Color myForeground;
    private boolean myCompact;
    private boolean myShowTagNames;

    public LabelPainter(@NotNull VcsLogData data, boolean compact, boolean showTagNames) {
        if (data == null) {
            LabelPainter.$$$reportNull$$$0(0);
        }
        this.myLabels = ContainerUtil.newArrayList();
        this.myHeight = JBUI.scale((int)22);
        this.myWidth = 0;
        this.myBackground = UIUtil.getTableBackground();
        this.myGreyBackground = null;
        this.myForeground = UIUtil.getTableForeground();
        this.myLogData = data;
        this.myCompact = compact;
        this.myShowTagNames = showTagNames;
    }

    @Nullable
    public static VcsLogRefManager getRefManager(@NotNull VcsLogData logData, @NotNull Collection<VcsRef> references) {
        if (logData == null) {
            LabelPainter.$$$reportNull$$$0(1);
        }
        if (references == null) {
            LabelPainter.$$$reportNull$$$0(2);
        }
        if (!references.isEmpty()) {
            VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references))).getRoot();
            return logData.getLogProvider(root).getReferenceManager();
        }
        return null;
    }

    public void customizePainter(@NotNull JComponent component, @NotNull Collection<VcsRef> references, @NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth) {
        if (component == null) {
            LabelPainter.$$$reportNull$$$0(3);
        }
        if (references == null) {
            LabelPainter.$$$reportNull$$$0(4);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(5);
        }
        if (foreground == null) {
            LabelPainter.$$$reportNull$$$0(6);
        }
        this.myBackground = background;
        this.myForeground = isSelected ? foreground : TEXT_COLOR;
        FontMetrics metrics = component.getFontMetrics(this.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING;
        VcsLogRefManager manager = LabelPainter.getRefManager(this.myLogData, references);
        List refGroups = manager == null ? ContainerUtil.emptyList() : manager.groupForTable(references, this.myCompact, this.myShowTagNames);
        this.myGreyBackground = LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        Pair<List<Pair<String, LabelIcon>>, Integer> presentation = LabelPainter.calculatePresentation(refGroups, metrics, this.myHeight, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = (List)presentation.first;
        this.myWidth = (Integer)presentation.second;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculatePresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth, boolean compact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(7);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(8);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(9);
        }
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair2 = Pair.create((Object)labels, (Object)width);
            if (pair2 == null) {
                LabelPainter.$$$reportNull$$$0(10);
            }
            return pair2;
        }
        if (compact) {
            Pair<List<Pair<String, LabelIcon>>, Integer> pair3 = LabelPainter.calculateCompactPresentation(refGroups, fontMetrics, height, background, availableWidth);
            if (pair3 == null) {
                LabelPainter.$$$reportNull$$$0(11);
            }
            return pair3;
        }
        Pair<List<Pair<String, LabelIcon>>, Integer> pair4 = LabelPainter.calculateLongPresentation(refGroups, fontMetrics, height, background, availableWidth);
        if (pair4 == null) {
            LabelPainter.$$$reportNull$$$0(12);
        }
        return pair4;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculateCompactPresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(13);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(14);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(15);
        }
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair2 = Pair.create((Object)labels, (Object)width);
            if (pair2 == null) {
                LabelPainter.$$$reportNull$$$0(16);
            }
            return pair2;
        }
        for (RefGroup group : refGroups) {
            List colors = group.getColors();
            LabelIcon labelIcon = new LabelIcon(height, background, colors.toArray(new Color[colors.size()]));
            int newWidth = width + labelIcon.getIconWidth() + (group != ContainerUtil.getLastItem(refGroups) ? COMPACT_MIDDLE_PADDING : 0);
            String text2 = LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth - newWidth);
            labels.add(Pair.create((Object)text2, (Object)labelIcon));
            width = newWidth += fontMetrics.stringWidth(text2);
        }
        Pair pair3 = Pair.create((Object)labels, (Object)width);
        if (pair3 == null) {
            LabelPainter.$$$reportNull$$$0(17);
        }
        return pair3;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculateLongPresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(18);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(19);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(20);
        }
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair2 = Pair.create((Object)labels, (Object)width);
            if (pair2 == null) {
                LabelPainter.$$$reportNull$$$0(21);
            }
            return pair2;
        }
        for (int i = 0; i < refGroups.size(); ++i) {
            String text2;
            RefGroup group = refGroups.get(i);
            int doNotFitWidth = 0;
            if (i < refGroups.size() - 1) {
                LabelIcon lastIcon = new LabelIcon(height, background, LabelPainter.getColors(refGroups.subList(i + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List colors = group.getColors();
            LabelIcon labelIcon = new LabelIcon(height, background, colors.toArray(new Color[colors.size()]));
            int newWidth = width + labelIcon.getIconWidth() + (i != refGroups.size() - 1 ? MIDDLE_PADDING : 0);
            if (availableWidth - (newWidth += fontMetrics.stringWidth(text2 = LabelPainter.getGroupText(group, fontMetrics, availableWidth - newWidth - doNotFitWidth))) - doNotFitWidth < 0) {
                LabelIcon lastIcon = new LabelIcon(height, background, LabelPainter.getColors(refGroups.subList(i, refGroups.size())));
                String name2 = labels.isEmpty() ? text2 : "";
                labels.add(Pair.create((Object)name2, (Object)lastIcon));
                width += fontMetrics.stringWidth(name2) + lastIcon.getIconWidth();
                break;
            }
            labels.add(Pair.create((Object)text2, (Object)labelIcon));
            width = newWidth;
        }
        Pair pair3 = Pair.create((Object)labels, (Object)width);
        if (pair3 == null) {
            LabelPainter.$$$reportNull$$$0(22);
        }
        return pair3;
    }

    @NotNull
    private static Color[] getColors(@NotNull Collection<RefGroup> groups) {
        if (groups == null) {
            LabelPainter.$$$reportNull$$$0(23);
        }
        LinkedHashMap usedColors = ContainerUtil.newLinkedHashMap();
        for (RefGroup group : groups) {
            List colors = group.getColors();
            for (Color color : colors) {
                Integer count = (Integer)usedColors.get(color);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color, count + 1);
            }
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Map.Entry entry : usedColors.entrySet()) {
            result2.add(entry.getKey());
            if ((Integer)entry.getValue() <= 1) continue;
            result2.add(entry.getKey());
        }
        Color[] colorArray = result2.toArray(new Color[result2.size()]);
        if (colorArray == null) {
            LabelPainter.$$$reportNull$$$0(24);
        }
        return colorArray;
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (group == null) {
            LabelPainter.$$$reportNull$$$0(25);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(26);
        }
        if (!group.isExpanded()) {
            String string = LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth);
            if (string == null) {
                LabelPainter.$$$reportNull$$$0(27);
            }
            return string;
        }
        StringBuilder text2 = new StringBuilder();
        String remainder = ", ...";
        String separator = ", ";
        int remainderWidth = fontMetrics.stringWidth(remainder);
        int separatorWidth = fontMetrics.stringWidth(separator);
        for (int i = 0; i < group.getRefs().size(); ++i) {
            String refName;
            int refNameWidth;
            boolean firstRef;
            boolean lastRef = i == group.getRefs().size() - 1;
            int width = availableWidth - (lastRef ? 0 : remainderWidth) - ((firstRef = i == 0) ? 0 : separatorWidth);
            if (width - (refNameWidth = fontMetrics.stringWidth(refName = LabelPainter.shortenRefName(((VcsRef)group.getRefs().get(i)).getName(), fontMetrics, width))) < 0 && !firstRef) {
                text2.append(remainder);
                break;
            }
            text2.append(firstRef ? "" : separator).append(refName);
            availableWidth -= (firstRef ? 0 : separatorWidth) + refNameWidth;
        }
        String string = text2.toString();
        if (string == null) {
            LabelPainter.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(29);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(30);
        }
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return ColorUtil.mix((Color)background, (Color)BACKGROUND, (double)0.08f);
        }
        for (RefGroup group : refGroups) {
            boolean paintGreyBackground;
            if (group.isExpanded()) {
                paintGreyBackground = ContainerUtil.find((Iterable)group.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !group.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return ColorUtil.mix((Color)background, (Color)BACKGROUND, (double)0.08f);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (refName == null) {
            LabelPainter.$$$reportNull$$$0(31);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(32);
        }
        if (fontMetrics.stringWidth(refName) > availableWidth && refName.length() > 22) {
            int separatorIndex = refName.indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + refName.substring(separatorIndex);
            }
            if (fontMetrics.stringWidth(refName) <= availableWidth) {
                String string = refName;
                if (string == null) {
                    LabelPainter.$$$reportNull$$$0(33);
                }
                return string;
            }
            if (availableWidth > 0) {
                for (int i = refName.length(); i > 22; --i) {
                    String result2 = StringUtil.shortenTextWithEllipsis((String)refName, (int)i, (int)0, (String)THREE_DOTS);
                    if (fontMetrics.stringWidth(result2) > availableWidth) continue;
                    String string = result2;
                    if (string == null) {
                        LabelPainter.$$$reportNull$$$0(34);
                    }
                    return string;
                }
            }
            String string = StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)THREE_DOTS);
            if (string == null) {
                LabelPainter.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = refName;
        if (string == null) {
            LabelPainter.$$$reportNull$$$0(36);
        }
        return string;
    }

    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (g2 == null) {
            LabelPainter.$$$reportNull$$$0(37);
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(this.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.setColor(this.myBackground);
        g2.fillRect(x, y, this.myWidth, height);
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING, this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING);
        }
        x += LEFT_PADDING;
        for (Pair<String, LabelIcon> label : this.myLabels) {
            LabelIcon icon = (LabelIcon)label.second;
            String text2 = (String)label.first;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x - LEFT_PADDING, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING, icon.getIconWidth() + fontMetrics.stringWidth(text2) + 3 * LEFT_PADDING, fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING, RectanglePainter.LABEL_ARC, RectanglePainter.LABEL_ARC));
            }
            icon.paintIcon(null, g2, x, y + (height - icon.getIconHeight()) / 2);
            g2.setColor(this.myForeground);
            g2.drawString(text2, x += icon.getIconWidth(), y + baseLine);
            x += fontMetrics.stringWidth(text2) + (this.myCompact ? COMPACT_MIDDLE_PADDING : MIDDLE_PADDING);
        }
        config.restore();
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return Registry.is((String)"vcs.log.labels.left.aligned");
    }

    public Font getReferenceFont() {
        Font font = RectanglePainter.getFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setShowTagNames(boolean showTagNames) {
        this.myShowTagNames = showTagNames;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 9: 
            case 15: 
            case 20: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refGroups";
                break;
            }
            case 8: 
            case 14: 
            case 19: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePresentation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCompactPresentation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLongPresentation";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupText";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenRefName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRefManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizePainter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculatePresentation";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculateCompactPresentation";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calculateLongPresentation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getGroupText";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "calculateGreyBackground";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shortenRefName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

