/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class EditBreakpointActionHandler
extends DebuggerActionHandler {
    protected abstract void doShowPopup(Project var1, JComponent var2, Point var3, Object var4);

    @Override
    public void perform(@NotNull Project project2, AnActionEvent event) {
        DataContext dataContext;
        Editor editor;
        if (project2 == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext = event.getDataContext())) == null) {
            return;
        }
        Pair<GutterIconRenderer, Object> pair2 = XBreakpointUtil.findSelectedBreakpoint(project2, editor);
        Object breakpoint = pair2.second;
        GutterIconRenderer breakpointGutterRenderer = (GutterIconRenderer)pair2.first;
        if (breakpointGutterRenderer == null) {
            return;
        }
        this.editBreakpoint(project2, editor, breakpoint, breakpointGutterRenderer);
    }

    public void editBreakpoint(@NotNull Project project2, @NotNull Editor editor, @NotNull Object breakpoint, @NotNull GutterIconRenderer breakpointGutterRenderer) {
        if (project2 == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(2);
        }
        if (breakpoint == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(3);
        }
        if (breakpointGutterRenderer == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(4);
        }
        if (BreakpointsDialogFactory.getInstance(project2).isBreakpointPopupShowing()) {
            return;
        }
        EditorGutterComponentEx gutterComponent = ((EditorEx)editor).getGutterComponentEx();
        Point point = gutterComponent.getCenterPoint(breakpointGutterRenderer);
        if (point == null) {
            point = new Point(gutterComponent.getWidth(), editor.visualPositionToXY((VisualPosition)editor.getCaretModel().getVisualPosition()).y + editor.getLineHeight() / 2);
        }
        this.doShowPopup(project2, gutterComponent, point, breakpoint);
    }

    public void editBreakpoint(@NotNull Project project2, @NotNull JComponent parent, @NotNull Point whereToShow, @NotNull BreakpointItem breakpoint) {
        if (project2 == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(6);
        }
        if (whereToShow == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(7);
        }
        if (breakpoint == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(8);
        }
        this.doShowPopup(project2, parent, whereToShow, breakpoint.getBreakpoint());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointGutterRenderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whereToShow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "editBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

