/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class XDebuggerSmartStepIntoHandler
extends XDebuggerSuspendedActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XDebuggerSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        return super.isEnabled(session2, dataContext) && session2.getDebugProcess().getSmartStepIntoHandler() != null;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XDebuggerSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        XSmartStepIntoHandler handler2 = session2.getDebugProcess().getSmartStepIntoHandler();
        XSourcePosition position = session2.getTopFramePosition();
        if (position == null || handler2 == null) {
            return;
        }
        FileEditor editor = FileEditorManager.getInstance((Project)session2.getProject()).getSelectedEditor(position.getFile());
        if (editor instanceof TextEditor) {
            XDebuggerSmartStepIntoHandler.doSmartStepInto(handler2, position, session2, ((TextEditor)editor).getEditor());
        }
    }

    private static <V extends XSmartStepIntoVariant> void doSmartStepInto(final XSmartStepIntoHandler<V> handler2, XSourcePosition position, final XDebugSession session2, Editor editor) {
        List variants = handler2.computeSmartStepVariants(position);
        if (variants.isEmpty()) {
            session2.stepInto();
            return;
        }
        if (variants.size() == 1) {
            session2.smartStepInto(handler2, (XSmartStepIntoVariant)variants.get(0));
            return;
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<V>(handler2.getPopupTitle(position), variants){

            public Icon getIconFor(V aValue) {
                return aValue.getIcon();
            }

            @NotNull
            public String getTextFor(V value2) {
                String string = value2.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(V selectedValue, boolean finalChoice) {
                session2.smartStepInto(handler2, selectedValue);
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$1", "getTextFor"));
            }
        });
        DebuggerUIUtil.showPopupForEditorLine((JBPopup)popup2, editor, position.getLine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "session";
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

