/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XExpressionState {
    @Attribute(value="disabled")
    public boolean myDisabled;
    @Attribute(value="expression")
    public String myExpression;
    @Attribute(value="language")
    public String myLanguage;
    @Attribute(value="custom")
    public String myCustomInfo;
    @Attribute(value="mode")
    public EvaluationMode myMode;
    @Text
    public String myOldExpression;

    public XExpressionState() {
        this.myMode = EvaluationMode.EXPRESSION;
    }

    public XExpressionState(boolean disabled, @NotNull String expression2, String language, String customInfo, EvaluationMode mode) {
        if (expression2 == null) {
            XExpressionState.$$$reportNull$$$0(0);
        }
        this.myMode = EvaluationMode.EXPRESSION;
        this.myDisabled = disabled;
        this.myExpression = expression2;
        this.myLanguage = language;
        this.myCustomInfo = customInfo;
        this.myMode = mode;
    }

    public XExpressionState(boolean disabled, XExpression expression2) {
        this(disabled, expression2.getExpression(), expression2.getLanguage() != null ? expression2.getLanguage().getID() : null, expression2.getCustomInfo(), expression2.getMode());
    }

    public XExpressionState(XExpression expression2) {
        this(false, expression2);
    }

    void checkConverted() {
        if (this.myOldExpression != null) {
            this.myExpression = this.myOldExpression;
            this.myOldExpression = null;
        }
    }

    @Nullable
    public XExpression toXExpression() {
        this.checkConverted();
        if (StringUtil.isEmptyOrSpaces((String)this.myExpression)) {
            return null;
        }
        return new XExpressionImpl(this.myExpression, Language.findLanguageByID((String)this.myLanguage), this.myCustomInfo, this.myMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/breakpoints/XExpressionState", "<init>"));
    }
}

