/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import com.intellij.xdebugger.impl.ui.BreakpointEditor;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DebuggerUIUtil {
    @NonNls
    public static final String FULL_VALUE_POPUP_DIMENSION_KEY = "XDebugger.FullValuePopup";

    private DebuggerUIUtil() {
    }

    public static void enableEditorOnCheck(JCheckBox checkbox, JComponent textfield) {
        checkbox.addActionListener(e -> {
            boolean selected = checkbox.isSelected();
            textfield.setEnabled(selected);
        });
        textfield.setEnabled(checkbox.isSelected());
    }

    public static void focusEditorOnCheck(JCheckBox checkbox, JComponent component) {
        Runnable runnable2 = () -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)component, true));
        checkbox.addActionListener(e -> {
            if (checkbox.isSelected()) {
                SwingUtilities.invokeLater(runnable2);
            }
        });
    }

    public static void invokeLater(Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    @Deprecated
    public static RelativePoint calcPopupLocation(@NotNull Editor editor, int line) {
        if (editor == null) {
            DebuggerUIUtil.$$$reportNull$$$0(0);
        }
        Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(p)) {
            p = new Point((visibleArea.x + visibleArea.width) / 2, (visibleArea.y + visibleArea.height) / 2);
        }
        return new RelativePoint((Component)editor.getContentComponent(), p);
    }

    @Nullable
    public static RelativePoint getPositionForPopup(@NotNull Editor editor, int line) {
        if (editor == null) {
            DebuggerUIUtil.$$$reportNull$$$0(1);
        }
        Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
        return editor.getScrollingModel().getVisibleArea().contains(p) ? new RelativePoint((Component)editor.getContentComponent(), p) : null;
    }

    public static void showPopupForEditorLine(@NotNull JBPopup popup2, @NotNull Editor editor, int line) {
        RelativePoint point;
        if (popup2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            DebuggerUIUtil.$$$reportNull$$$0(3);
        }
        if ((point = DebuggerUIUtil.getPositionForPopup(editor, line)) != null) {
            popup2.show(point);
        } else {
            Project project2 = editor.getProject();
            if (project2 != null) {
                popup2.showCenteredInCurrentWindow(project2);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    public static void showValuePopup(@NotNull XFullValueEvaluator evaluator, @NotNull MouseEvent event, @NotNull Project project2, @Nullable Editor editor) {
        if (evaluator == null) {
            DebuggerUIUtil.$$$reportNull$$$0(4);
        }
        if (event == null) {
            DebuggerUIUtil.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(6);
        }
        TextViewer textArea = new TextViewer(XDebuggerUIConstants.EVALUATING_EXPRESSION_MESSAGE, project2);
        textArea.setBackground(HintUtil.getInformationColor());
        FullValueEvaluationCallbackImpl callback = new FullValueEvaluationCallbackImpl(textArea);
        evaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback);
        Dimension size = DimensionService.getInstance().getSize(FULL_VALUE_POPUP_DIMENSION_KEY, project2);
        if (size == null) {
            Dimension frameSize = WindowManager.getInstance().getFrame(project2).getSize();
            size = new Dimension(frameSize.width / 2, frameSize.height / 2);
        }
        textArea.setPreferredSize(size);
        JBPopup popup2 = DebuggerUIUtil.createValuePopup(project2, (JComponent)((Object)textArea), callback);
        if (editor == null) {
            Rectangle bounds = new Rectangle(event.getLocationOnScreen(), size);
            ScreenUtil.fitToScreenVertical((Rectangle)bounds, (int)5, (int)5, (boolean)true);
            if (size.width != bounds.width || size.height != bounds.height) {
                size = bounds.getSize();
                textArea.setPreferredSize(size);
            }
            popup2.showInScreenCoordinates(event.getComponent(), bounds.getLocation());
        } else {
            popup2.showInBestPositionFor(editor);
        }
    }

    public static JBPopup createValuePopup(Project project2, JComponent component, @Nullable FullValueEvaluationCallbackImpl callback) {
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(component, null);
        builder.setResizable(true).setMovable(true).setDimensionServiceKey(project2, FULL_VALUE_POPUP_DIMENSION_KEY, false).setRequestFocus(false);
        if (callback != null) {
            builder.setCancelCallback(() -> {
                callback.setObsolete();
                return true;
            });
        }
        return builder.createPopup();
    }

    public static void showXBreakpointEditorBalloon(Project project2, @Nullable Point point, JComponent component, boolean showAllOptions, final XBreakpoint breakpoint) {
        final XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        final XLightBreakpointPropertiesPanel propertiesPanel = new XLightBreakpointPropertiesPanel(project2, breakpointManager, (XBreakpointBase)breakpoint, showAllOptions);
        Ref balloonRef = Ref.create(null);
        Ref isLoading = Ref.create((Object)Boolean.FALSE);
        Ref moreOptionsRequested = Ref.create((Object)Boolean.FALSE);
        propertiesPanel.setDelegate(() -> {
            if (!((Boolean)isLoading.get()).booleanValue()) {
                propertiesPanel.saveProperties();
            }
            if (!balloonRef.isNull()) {
                ((Balloon)balloonRef.get()).hide();
            }
            propertiesPanel.dispose();
            DebuggerUIUtil.showXBreakpointEditorBalloon(project2, point, component, true, breakpoint);
            moreOptionsRequested.set((Object)true);
        });
        isLoading.set((Object)Boolean.TRUE);
        propertiesPanel.loadProperties();
        isLoading.set((Object)Boolean.FALSE);
        if (((Boolean)moreOptionsRequested.get()).booleanValue()) {
            return;
        }
        Runnable showMoreOptions = () -> {
            propertiesPanel.saveProperties();
            propertiesPanel.dispose();
            BreakpointsDialogFactory.getInstance(project2).showDialog(breakpoint);
        };
        JPanel mainPanel = propertiesPanel.getMainPanel();
        final Balloon balloon = DebuggerUIUtil.showBreakpointEditor(project2, mainPanel, point, component, showMoreOptions, breakpoint);
        balloonRef.set((Object)balloon);
        final XBreakpointListener breakpointListener = new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> removedBreakpoint) {
                if (removedBreakpoint == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (removedBreakpoint.equals((Object)breakpoint)) {
                    balloon.hide();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedBreakpoint", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$1", "breakpointRemoved"));
            }
        };
        balloon.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                propertiesPanel.saveProperties();
                propertiesPanel.dispose();
                breakpointManager.removeBreakpointListener(breakpointListener);
            }
        });
        breakpointManager.addBreakpointListener(breakpointListener);
        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.findInstance().requestFocus((Component)mainPanel, true));
    }

    public static Balloon showBreakpointEditor(Project project2, JComponent mainPanel, Point whereToShow, JComponent component, final @Nullable Runnable showMoreOptions, Object breakpoint) {
        BreakpointEditor editor = new BreakpointEditor();
        editor.setPropertiesPanel(mainPanel);
        editor.setShowMoreOptionsLink(true);
        JPanel panel2 = editor.getMainPanel();
        final Balloon balloon = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel2, null).setHideOnClickOutside(true).setCloseButtonEnabled(false).setAnimationCycle(0).setBlockClicksThroughBalloon(true).createBalloon();
        editor.setDelegate(new BreakpointEditor.Delegate(){

            @Override
            public void done() {
                balloon.hide();
            }

            @Override
            public void more() {
                assert (showMoreOptions != null);
                balloon.hide();
                showMoreOptions.run();
            }
        });
        ComponentAdapter moveListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                balloon.hide();
            }
        };
        component.addComponentListener(moveListener);
        Disposer.register((Disposable)balloon, () -> component.removeComponentListener(moveListener));
        HierarchyBoundsAdapter hierarchyBoundsListener = new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                balloon.hide();
            }
        };
        component.addHierarchyBoundsListener(hierarchyBoundsListener);
        Disposer.register((Disposable)balloon, () -> component.removeHierarchyBoundsListener(hierarchyBoundsListener));
        if (whereToShow == null) {
            balloon.showInCenterOf(component);
        } else {
            Window window = SwingUtilities.windowForComponent(component);
            RelativePoint p = new RelativePoint((Component)component, whereToShow);
            if (window != null) {
                RelativePoint point = new RelativePoint((Component)window, new Point(0, 0));
                if (p.getScreenPoint().getX() - point.getScreenPoint().getX() < 40.0) {
                    p.getPoint().x += 40;
                }
            }
            balloon.show(p, Balloon.Position.below);
        }
        BreakpointsDialogFactory.getInstance(project2).setBalloonToHide(balloon, breakpoint);
        return balloon;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        if (editorColorsScheme == null) {
            DebuggerUIUtil.$$$reportNull$$$0(7);
        }
        return editorColorsScheme;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme(@Nullable JComponent component) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getColorSchemeForComponent((JComponent)component);
        if (editorColorsScheme == null) {
            DebuggerUIUtil.$$$reportNull$$$0(8);
        }
        return editorColorsScheme;
    }

    @Nullable
    public static String getNodeRawValue(@NotNull XValueNodeImpl valueNode) {
        if (valueNode == null) {
            DebuggerUIUtil.$$$reportNull$$$0(9);
        }
        if (valueNode.getValueContainer() instanceof XValueTextProvider) {
            return ((XValueTextProvider)valueNode.getValueContainer()).getValueText();
        }
        return valueNode.getRawValue();
    }

    public static boolean hasEvaluationExpression(@NotNull XValue value2) {
        Promise promise2;
        if (value2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(10);
        }
        if ((promise2 = value2.calculateEvaluationExpression()).getState() == Promise.State.PENDING) {
            return true;
        }
        if (promise2 instanceof Getter) {
            return ((Getter)promise2).get() != null;
        }
        return true;
    }

    public static void registerActionOnComponent(String name2, JComponent component, Disposable parentDisposable) {
        AnAction action = ActionManager.getInstance().getAction(name2);
        action.registerCustomShortcutSet(action.getShortcutSet(), component, parentDisposable);
    }

    public static void registerExtraHandleShortcuts(final ListPopupImpl popup2, String ... actionNames) {
        for (String name2 : actionNames) {
            KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(name2).getShortcutSet());
            if (stroke == null) continue;
            popup2.registerAction("handleSelection " + stroke, stroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    popup2.handleSelect(true);
                }
            });
        }
    }

    @NotNull
    public static String getSelectionShortcutsAdText(String ... actionNames) {
        String string = DebuggerUIUtil.getShortcutsAdText("ad.extra.selection.shortcut", actionNames);
        if (string == null) {
            DebuggerUIUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getShortcutsAdText(String key2, String ... actionNames) {
        String text2 = StreamEx.of((Object[])actionNames).map(DebuggerUIUtil::getActionShortcutText).nonNull().joining((CharSequence)XDebuggerBundle.message((String)"xdebugger.shortcuts.text.delimiter", (Object[])new Object[0]));
        String string = StringUtil.isEmpty((String)text2) ? "" : XDebuggerBundle.message((String)key2, (Object[])new Object[]{text2});
        if (string == null) {
            DebuggerUIUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static String getActionShortcutText(String actionName) {
        KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(actionName).getShortcutSet());
        if (stroke != null) {
            return KeymapUtil.getKeystrokeText((KeyStroke)stroke);
        }
        return null;
    }

    public static boolean isObsolete(Object object) {
        return object instanceof Obsolescent && ((Obsolescent)object).isObsolete();
    }

    public static void setTreeNodeValue(XValueNodeImpl valueNode, String text2, final Consumer<String> errorConsumer) {
        final XDebuggerTree tree = valueNode.getTree();
        final Project project2 = tree.getProject();
        XValueModifier modifier = ((XValue)valueNode.getValueContainer()).getModifier();
        if (modifier == null) {
            return;
        }
        final XDebuggerTreeState treeState = XDebuggerTreeState.saveState(tree);
        valueNode.setValueModificationStarted();
        modifier.setValue(text2, new XValueModifier.XModificationCallback(){

            public void valueModified() {
                if (tree.isDetached()) {
                    AppUIUtil.invokeOnEdt(() -> tree.rebuildAndRestore(treeState));
                }
                XDebuggerUtilImpl.rebuildAllSessionsViews(project2);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    7.$$$reportNull$$$0(0);
                }
                AppUIUtil.invokeOnEdt(() -> {
                    if (errorMessage == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    tree.rebuildAndRestore(treeState);
                    errorConsumer.consume((Object)errorMessage);
                });
                XDebuggerUtilImpl.rebuildAllSessionsViews(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "errorMessage";
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$errorOccurred$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean isInDetachedTree(AnActionEvent event) {
        return event.getData(XDebugSessionTab.TAB_KEY) == null;
    }

    public static XDebugSessionData getSessionData(AnActionEvent e) {
        XDebugSession session2;
        Project project2;
        XDebugSessionData data = (XDebugSessionData)((Object)e.getData(XDebugSessionData.DATA_KEY));
        if (data == null && (project2 = e.getProject()) != null && (session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null) {
            data = ((XDebugSessionImpl)session2).getSessionData();
        }
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionShortcutsAdText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutsAdText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcPopupLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPositionForPopup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showPopupForEditorLine";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showValuePopup";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRawValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasEvaluationExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FullValueEvaluationCallbackImpl
    implements XFullValueEvaluator.XFullValueEvaluationCallback {
        private final AtomicBoolean myObsolete = new AtomicBoolean(false);
        private final EditorTextField myTextArea;

        public FullValueEvaluationCallbackImpl(EditorTextField textArea) {
            this.myTextArea = textArea;
        }

        public void evaluated(@NotNull String fullValue) {
            if (fullValue == null) {
                FullValueEvaluationCallbackImpl.$$$reportNull$$$0(0);
            }
            this.evaluated(fullValue, null);
        }

        public void evaluated(@NotNull String fullValue, @Nullable Font font) {
            if (fullValue == null) {
                FullValueEvaluationCallbackImpl.$$$reportNull$$$0(1);
            }
            AppUIUtil.invokeOnEdt(() -> {
                if (fullValue == null) {
                    FullValueEvaluationCallbackImpl.$$$reportNull$$$0(4);
                }
                this.myTextArea.setText(fullValue);
                if (font != null) {
                    this.myTextArea.setFont(font);
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                FullValueEvaluationCallbackImpl.$$$reportNull$$$0(2);
            }
            AppUIUtil.invokeOnEdt(() -> {
                if (errorMessage == null) {
                    FullValueEvaluationCallbackImpl.$$$reportNull$$$0(3);
                }
                this.myTextArea.setForeground(XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES.getFgColor());
                this.myTextArea.setText(errorMessage);
            });
        }

        private void setObsolete() {
            this.myObsolete.set(true);
        }

        public boolean isObsolete() {
            return this.myObsolete.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$errorOccurred$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$evaluated$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

