/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.util.Comparing;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class XDebuggerTreeRestorer
implements XDebuggerTreeListener,
TreeSelectionListener {
    public static final String SELECTION_PATH_PROPERTY = "selection.path";
    private final XDebuggerTree myTree;
    private final Rectangle myLastVisibleNodeRect;
    private final Map<XDebuggerTreeNode, XDebuggerTreeState.NodeInfo> myNode2State = new HashMap<XDebuggerTreeNode, XDebuggerTreeState.NodeInfo>();
    private final Map<RestorableStateNode, XDebuggerTreeState.NodeInfo> myNode2ParentState = new HashMap<RestorableStateNode, XDebuggerTreeState.NodeInfo>();
    private boolean myStopRestoringSelection;
    private boolean myInsideRestoring;
    private TreePath mySelectionPath;
    private boolean myFinished;

    public XDebuggerTreeRestorer(XDebuggerTree tree, Rectangle lastVisibleNodeRect) {
        this.myTree = tree;
        this.myLastVisibleNodeRect = lastVisibleNodeRect;
        this.mySelectionPath = (TreePath)this.myTree.getClientProperty(SELECTION_PATH_PROPERTY);
        this.myTree.putClientProperty(SELECTION_PATH_PROPERTY, null);
        tree.addTreeListener(this);
        tree.addTreeSelectionListener(this);
    }

    private void restoreChildren(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo nodeInfo) {
        if (nodeInfo.isExpanded()) {
            this.myTree.expandPath(treeNode.getPath());
            treeNode.getLoadedChildren().forEach(child -> this.restoreNode((XDebuggerTreeNode)child, nodeInfo));
            this.myNode2State.put(treeNode, nodeInfo);
        }
    }

    void restore(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo parentInfo) {
        if (treeNode instanceof RestorableStateNode) {
            this.doRestoreNode((RestorableStateNode)((Object)treeNode), parentInfo);
        } else {
            this.restoreChildren(treeNode, parentInfo);
        }
    }

    private void restoreNode(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo parentInfo) {
        if (treeNode instanceof RestorableStateNode) {
            RestorableStateNode node = (RestorableStateNode)((Object)treeNode);
            if (node.isComputed()) {
                this.doRestoreNode(node, parentInfo.getChild(node));
            } else {
                this.myNode2ParentState.put(node, parentInfo);
            }
        }
    }

    private void doRestoreNode(RestorableStateNode treeNode, XDebuggerTreeState.NodeInfo nodeInfo) {
        if (nodeInfo != null) {
            if (!XDebuggerTreeRestorer.checkExtendedModified(treeNode) && !Comparing.equal((String)nodeInfo.getValue(), (String)treeNode.getRawValue())) {
                treeNode.markChanged();
            }
            if (!this.myStopRestoringSelection && nodeInfo.isSelected() && this.mySelectionPath == null) {
                try {
                    this.myInsideRestoring = true;
                    this.myTree.addSelectionPath(treeNode.getPath());
                }
                finally {
                    this.myInsideRestoring = false;
                }
            }
            if (!treeNode.isComputed() || !treeNode.isLeaf()) {
                this.restoreChildren((XDebuggerTreeNode)((Object)treeNode), nodeInfo);
            }
        } else {
            if (!XDebuggerTreeRestorer.checkExtendedModified(treeNode)) {
                treeNode.markChanged();
            }
            if (this.mySelectionPath != null && !this.myStopRestoringSelection && XDebuggerTreeRestorer.pathsEqual(this.mySelectionPath, treeNode.getPath())) {
                this.myTree.addSelectionPath(treeNode.getPath());
            }
        }
    }

    private static boolean pathsEqual(@NotNull TreePath path1, @NotNull TreePath path2) {
        if (path1 == null) {
            XDebuggerTreeRestorer.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            XDebuggerTreeRestorer.$$$reportNull$$$0(1);
        }
        if (path1.getPathCount() != path2.getPathCount()) {
            return false;
        }
        do {
            Object component1 = path1.getLastPathComponent();
            Object component2 = path2.getLastPathComponent();
            if (component1 instanceof XNamedTreeNode && component2 instanceof XNamedTreeNode && !Comparing.equal((String)((XNamedTreeNode)component1).getName(), (String)((XNamedTreeNode)component2).getName())) {
                return false;
            }
            path1 = path1.getParentPath();
            path2 = path2.getParentPath();
        } while (path1 != null && path2 != null);
        return true;
    }

    private static boolean checkExtendedModified(RestorableStateNode treeNode) {
        XValuePresentation presentation;
        if (treeNode instanceof XValueNodeImpl && (presentation = ((XValueNodeImpl)treeNode).getValuePresentation()) instanceof XValueExtendedPresentation) {
            if (((XValueExtendedPresentation)presentation).isModified()) {
                treeNode.markChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    public void nodeLoaded(@NotNull RestorableStateNode node, String name2) {
        XDebuggerTreeState.NodeInfo parentInfo;
        if (node == null) {
            XDebuggerTreeRestorer.$$$reportNull$$$0(2);
        }
        if ((parentInfo = this.myNode2ParentState.remove(node)) != null) {
            this.doRestoreNode(node, parentInfo.getChild(node));
        }
        this.disposeIfFinished();
    }

    private void disposeIfFinished() {
        if (this.myNode2ParentState.isEmpty() && this.myNode2State.isEmpty()) {
            this.myFinished = true;
            if (this.myLastVisibleNodeRect != null) {
                this.myTree.scrollRectToVisible(this.myLastVisibleNodeRect);
            }
            this.dispose();
        }
    }

    @Override
    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children2, boolean last) {
        XDebuggerTreeState.NodeInfo nodeInfo;
        if (node == null) {
            XDebuggerTreeRestorer.$$$reportNull$$$0(3);
        }
        if (children2 == null) {
            XDebuggerTreeRestorer.$$$reportNull$$$0(4);
        }
        if ((nodeInfo = this.myNode2State.get(node)) != null) {
            for (XDebuggerTreeNode xDebuggerTreeNode : children2) {
                this.restoreNode(xDebuggerTreeNode, nodeInfo);
            }
        }
        if (last) {
            this.myNode2State.remove(node);
            this.disposeIfFinished();
        }
    }

    public void dispose() {
        this.myNode2ParentState.clear();
        this.myNode2State.clear();
        this.myTree.removeTreeListener(this);
        this.myTree.removeTreeSelectionListener(this);
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.myInsideRestoring) {
            this.myStopRestoringSelection = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pathsEqual";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "nodeLoaded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenLoaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

