/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlTagInplaceRenamer {
    @NonNls
    private static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OtherVariable";
    private final Editor myEditor;
    private static final Stack<XmlTagInplaceRenamer> ourRenamersStack = new Stack();
    private ArrayList<RangeHighlighter> myHighlighters;

    private XmlTagInplaceRenamer(@NotNull Editor editor) {
        if (editor == null) {
            XmlTagInplaceRenamer.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
    }

    public static void rename(Editor editor, @NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagInplaceRenamer.$$$reportNull$$$0(1);
        }
        if (!ourRenamersStack.isEmpty()) {
            ((XmlTagInplaceRenamer)ourRenamersStack.peek()).finish();
        }
        XmlTagInplaceRenamer renamer = new XmlTagInplaceRenamer(editor);
        ourRenamersStack.push((Object)renamer);
        renamer.rename(tag);
    }

    private void rename(@NotNull XmlTag tag) {
        Pair<ASTNode, ASTNode> pair2;
        if (tag == null) {
            XmlTagInplaceRenamer.$$$reportNull$$$0(2);
        }
        if ((pair2 = this.getNamePair(tag)) == null) {
            return;
        }
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            ArrayList<TextRange> highlightRanges = new ArrayList<TextRange>();
            highlightRanges.add(((ASTNode)pair2.first).getTextRange());
            if (pair2.second != null) {
                highlightRanges.add(((ASTNode)pair2.second).getTextRange());
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)tag)) {
                return;
            }
            this.myHighlighters = new ArrayList();
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                if (tag == null) {
                    XmlTagInplaceRenamer.$$$reportNull$$$0(6);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (tag == null) {
                        XmlTagInplaceRenamer.$$$reportNull$$$0(7);
                    }
                    int offset = this.myEditor.getCaretModel().getOffset();
                    this.myEditor.getCaretModel().moveToOffset(tag.getTextOffset());
                    Template t = XmlTagInplaceRenamer.buildTemplate(tag, pair2);
                    TemplateManager.getInstance(project2).startTemplate(this.myEditor, t, new TemplateEditingAdapter(){

                        @Override
                        public void templateFinished(Template template, boolean brokenOff) {
                            XmlTagInplaceRenamer.this.finish();
                        }

                        @Override
                        public void templateCancelled(Template template) {
                            XmlTagInplaceRenamer.this.finish();
                        }
                    }, (PairProcessor<String, String>)((PairProcessor)(variableName, value2) -> value2.length() == 0 || value2.charAt(value2.length() - 1) != ' '));
                    this.myEditor.getCaretModel().moveToOffset(offset);
                    XmlTagInplaceRenamer.addHighlights(highlightRanges, this.myEditor, this.myHighlighters);
                });
            }, RefactoringBundle.message((String)"rename.title"), null);
        }
    }

    private void finish() {
        Project project2;
        ourRenamersStack.pop();
        if (this.myHighlighters != null && (project2 = this.myEditor.getProject()) != null && !project2.isDisposed()) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
            }
        }
    }

    private Pair<ASTNode, ASTNode> getNamePair(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagInplaceRenamer.$$$reportNull$$$0(3);
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        if (startTagName == null) {
            return null;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(node);
        ASTNode selected = endTagName == null || startTagName.getTextRange().contains(offset) || startTagName.getTextRange().contains(offset - 1) ? startTagName : endTagName;
        ASTNode other = selected == startTagName ? endTagName : startTagName;
        return Pair.create((Object)selected, (Object)other);
    }

    private static Template buildTemplate(@NotNull XmlTag tag, @NotNull Pair<ASTNode, ASTNode> pair2) {
        if (tag == null) {
            XmlTagInplaceRenamer.$$$reportNull$$$0(4);
        }
        if (pair2 == null) {
            XmlTagInplaceRenamer.$$$reportNull$$$0(5);
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)tag);
        final ASTNode selected = (ASTNode)pair2.first;
        ASTNode other = (ASTNode)pair2.second;
        builder.replaceElement(selected.getPsi(), PRIMARY_VARIABLE_NAME, (Expression)new EmptyExpression(){

            @Override
            public Result calculateQuickResult(ExpressionContext context) {
                return new TextResult(selected.getText());
            }

            @Override
            public Result calculateResult(ExpressionContext context) {
                return new TextResult(selected.getText());
            }
        }, true);
        if (other != null) {
            builder.replaceElement(other.getPsi(), OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
        return builder.buildInlineTemplate();
    }

    private static void addHighlights(List<TextRange> ranges, Editor editor, ArrayList<RangeHighlighter> highlighters) {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        for (TextRange range : ranges) {
            highlightManager.addOccurrenceHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, 0, highlighters, null);
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/refactoring/XmlTagInplaceRenamer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamePair";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$rename$2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

