/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.IconUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.JsonSchemaConfigurable;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaPatternComparator;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA = "settings.json.schema";
    public static final String JSON_SCHEMA_MAPPINGS = "JSON Schema";
    private static final Comparator<UserDefinedJsonSchemaConfiguration> COMPARATOR = (o1, o2) -> {
        if (o1.isApplicationLevel() != o2.isApplicationLevel()) {
            return o1.isApplicationLevel() ? -1 : 1;
        }
        return o1.getName().compareToIgnoreCase(o2.getName());
    };
    public static final String READ_JSON_SCHEMA = "Read JSON Schema";
    public static final String ADD_PROJECT_SCHEMA = "Add Project Schema";
    private String myError;
    @NotNull
    private final Project myProject;
    private final Runnable myTreeUpdater;

    public JsonSchemaMappingsConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(0);
        }
        this.myTreeUpdater = () -> {
            this.TREE_UPDATER.run();
            this.updateWarningText();
        };
        this.myProject = project2;
        this.initTree();
    }

    @Nullable
    protected String getEmptySelectionString() {
        return this.myRoot.children().hasMoreElements() ? "Select JSON Schema to view" : "Please add a JSON Schema file and configure its usage";
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new DumbAwareAction("Add", "Add", IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)JsonSchemaMappingsConfigurable.this.myTree);
            }

            public void actionPerformed(AnActionEvent e) {
                JsonSchemaMappingsConfigurable.this.addProjectSchema();
            }
        });
        result2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return result2;
    }

    private void addProjectSchema() {
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(JsonBundle.message("json.schema.add.schema.chooser.title", new Object[0])), (Project)this.myProject, null);
        if (file2 != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)this.myProject.getBaseDir());
            if (relativePath == null) {
                Messages.showErrorDialog((Project)this.myProject, (String)"Please select file under project root.", (String)ADD_PROJECT_SCHEMA);
                return;
            }
            String error = JsonSchemaReader.checkIfValidJsonSchema(this.myProject, file2);
            if (error != null) {
                JsonSchemaReader.ERRORS_NOTIFICATION.createNotification(error, MessageType.ERROR).notify(this.myProject);
                Messages.showErrorDialog((Project)this.myProject, (String)error, (String)READ_JSON_SCHEMA);
                return;
            }
            this.addCreatedMappings(file2, new UserDefinedJsonSchemaConfiguration(file2.getNameWithoutExtension(), relativePath, false, null));
        }
    }

    private void addCreatedMappings(@NotNull VirtualFile schemaFile, @NotNull UserDefinedJsonSchemaConfiguration info) {
        if (schemaFile == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(1);
        }
        if (info == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(2);
        }
        JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, FileUtil.toSystemDependentName((String)schemaFile.getPath()), info, this.myTreeUpdater);
        configurable.setError(this.myError);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable, info.isApplicationLevel());
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node, true);
    }

    private void fillTree() {
        this.myRoot.removeAllChildren();
        if (this.myProject.isDefault()) {
            return;
        }
        List<UserDefinedJsonSchemaConfiguration> list2 = this.getStoredList();
        for (UserDefinedJsonSchemaConfiguration info : list2) {
            JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, new File(this.myProject.getBasePath(), info.getRelativePathToSchema()).getPath(), info, this.myTreeUpdater);
            configurable.setError(this.myError);
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)configurable, info.isApplicationLevel()));
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        if (this.myRoot.children().hasMoreElements()) {
            this.myTree.addSelectionRow(0);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getStoredList() {
        ArrayList<UserDefinedJsonSchemaConfiguration> list2 = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Map<String, UserDefinedJsonSchemaConfiguration> projectState = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).getStateMap();
        if (projectState != null) {
            list2.addAll(projectState.values());
        }
        Collections.sort(list2, COMPARATOR);
        ArrayList<UserDefinedJsonSchemaConfiguration> arrayList = list2;
        if (arrayList == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void apply() throws ConfigurationException {
        Project[] projects;
        List<UserDefinedJsonSchemaConfiguration> uiList = this.getUiList(true);
        JsonSchemaMappingsConfigurable.validate(uiList);
        HashMap<String, UserDefinedJsonSchemaConfiguration> projectMap = new HashMap<String, UserDefinedJsonSchemaConfiguration>();
        for (UserDefinedJsonSchemaConfiguration info : uiList) {
            if (info.isApplicationLevel()) continue;
            projectMap.put(info.getName(), info);
        }
        JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).setState(projectMap);
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            JsonSchemaService service = JsonSchemaService.Impl.get(project2);
            if (service == null) continue;
            service.reset();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    private static void validate(@NotNull List<UserDefinedJsonSchemaConfiguration> list2) throws ConfigurationException {
        if (list2 == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(4);
        }
        HashSet<String> set2 = new HashSet<String>();
        for (UserDefinedJsonSchemaConfiguration info : list2) {
            if (set2.contains(info.getName())) {
                throw new ConfigurationException("Duplicate schema name: '" + info.getName() + "'");
            }
            set2.add(info.getName());
        }
    }

    public boolean isModified() {
        List<UserDefinedJsonSchemaConfiguration> uiList;
        List<UserDefinedJsonSchemaConfiguration> storedList = this.getStoredList();
        try {
            uiList = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return false;
        }
        return !storedList.equals(uiList);
    }

    private void updateWarningText() {
        List<UserDefinedJsonSchemaConfiguration> list2;
        MultiMap patternsMap = new MultiMap();
        StringBuilder sb = new StringBuilder();
        try {
            list2 = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return;
        }
        for (UserDefinedJsonSchemaConfiguration info : list2) {
            JsonSchemaPatternComparator comparator2 = new JsonSchemaPatternComparator(this.myProject);
            List<UserDefinedJsonSchemaConfiguration.Item> patterns = info.getPatterns();
            for (UserDefinedJsonSchemaConfiguration.Item pattern : patterns) {
                for (Map.Entry entry : patternsMap.entrySet()) {
                    for (UserDefinedJsonSchemaConfiguration.Item item : (Collection)entry.getValue()) {
                        ThreeState similar = comparator2.isSimilar(pattern, item);
                        if (ThreeState.NO.equals((Object)similar)) continue;
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append("'").append(pattern.getPresentation()).append("' for schema '").append(info.getName()).append("' and '").append(item.getPresentation()).append("' for schema '").append((String)entry.getKey()).append("'");
                    }
                }
            }
            patternsMap.put((Object)info.getName(), patterns);
        }
        this.myError = sb.length() > 0 ? "Conflicting mappings:\n" + sb.toString() : null;
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode) || !(((MasterDetailsComponent.MyNode)o).getConfigurable() instanceof JsonSchemaConfigurable)) continue;
            ((JsonSchemaConfigurable)((MasterDetailsComponent.MyNode)o).getConfigurable()).setError(this.myError);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getUiList(boolean applyChildren) throws ConfigurationException {
        ArrayList<UserDefinedJsonSchemaConfiguration> uiList = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)children2.nextElement();
            if (applyChildren) {
                node.getConfigurable().apply();
                uiList.add(JsonSchemaMappingsConfigurable.getSchemaInfo(node));
                continue;
            }
            uiList.add(((JsonSchemaConfigurable)node.getConfigurable()).getUiSchema());
        }
        Collections.sort(uiList, COMPARATOR);
        ArrayList<UserDefinedJsonSchemaConfiguration> arrayList = uiList;
        if (arrayList == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void reset() {
        this.fillTree();
        this.updateWarningText();
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return (o1, o2) -> {
            if (o1.getConfigurable() instanceof JsonSchemaConfigurable && o2.getConfigurable() instanceof JsonSchemaConfigurable) {
                return COMPARATOR.compare(JsonSchemaMappingsConfigurable.getSchemaInfo(o1), JsonSchemaMappingsConfigurable.getSchemaInfo(o2));
            }
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        };
    }

    private static UserDefinedJsonSchemaConfiguration getSchemaInfo(@NotNull MasterDetailsComponent.MyNode node) {
        if (node == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(6);
        }
        return ((JsonSchemaConfigurable)node.getConfigurable()).getSchema();
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nls
    public String getDisplayName() {
        return JSON_SCHEMA_MAPPINGS;
    }

    public void dispose() {
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode)) continue;
            ((MasterDetailsComponent.MyNode)o).getConfigurable().disposeUIResources();
        }
    }

    @NotNull
    public String getId() {
        if (SETTINGS_JSON_SCHEMA == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(7);
        }
        return SETTINGS_JSON_SCHEMA;
    }

    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCreatedMappings";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

