/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, true);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, false);
    }

    @Nullable
    private static String findSchemaAndGenerateDoc(PsiElement element, @Nullable PsiElement originalElement, boolean preferShort) {
        PsiFile containingFile = (element = (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)element)).getContainingFile();
        if (containingFile == null) {
            return null;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(element.getProject());
        JsonSchemaObject rootSchema = service.getSchemaObject(containingFile.getViewProvider().getVirtualFile());
        if (rootSchema == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc(element, rootSchema, preferShort);
    }

    @Nullable
    public static String generateDoc(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, boolean preferShort) {
        JsonLikePsiWalker walker;
        if (element == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element, rootSchema)) == null) {
            return null;
        }
        PsiElement checkable = walker.goUpToCheckable(element);
        if (checkable == null) {
            return null;
        }
        List<JsonSchemaVariantsTreeBuilder.Step> position = walker.findPosition(checkable, true, true);
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(rootSchema, true, position).resolve();
        String text2 = schemas.stream().filter(schema -> !StringUtil.isEmptyOrSpaces((String)schema.getDocumentation(preferShort))).findFirst().map(schema -> schema.getDocumentation(preferShort)).orElse(null);
        return text2 == null ? null : StringUtil.escapeXml((String)text2).replace("\\n", "<br/>");
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rootSchema";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
        objectArray[2] = "generateDoc";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

