/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToForLoopParameterInspectionBase
extends BaseInspection {
    public boolean m_checkForeachParameters = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.for.loop.parameter.display.name", new Object[0]);
        if (string == null) {
            AssignmentToForLoopParameterInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.for.loop.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            AssignmentToForLoopParameterInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assignment.to.for.loop.parameter.check.foreach.option", new Object[0]), (InspectionProfileEntry)this, "m_checkForeachParameters");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToForLoopParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/assignment/AssignmentToForLoopParameterInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AssignmentToForLoopParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToForLoopParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                AssignmentToForLoopParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression2);
            if (expression2.getRExpression() == null) {
                return;
            }
            PsiExpression lhs = expression2.getLExpression();
            this.checkForForLoopParam(lhs);
            this.checkForForeachLoopParam(lhs);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression2) {
            if (expression2 == null) {
                AssignmentToForLoopParameterVisitor.$$$reportNull$$$0(1);
            }
            super.visitUnaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            this.checkForForLoopParam(operand2);
            this.checkForForeachLoopParam(operand2);
        }

        private void checkForForLoopParam(PsiExpression expression2) {
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)element;
            PsiElement variableParent = variable.getParent();
            if (!(variableParent instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)variableParent;
            PsiElement parent = declarationStatement.getParent();
            if (!(parent instanceof PsiForStatement)) {
                return;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return;
            }
            if (!initialization.equals(declarationStatement)) {
                return;
            }
            if (!this.isInForStatementBody(expression2, forStatement)) {
                return;
            }
            this.registerError((PsiElement)expression2, Boolean.FALSE);
        }

        private void checkForForeachLoopParam(PsiExpression expression2) {
            if (!AssignmentToForLoopParameterInspectionBase.this.m_checkForeachParameters) {
                return;
            }
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)element;
            if (!(parameter2.getParent() instanceof PsiForeachStatement)) {
                return;
            }
            this.registerError((PsiElement)expression2, Boolean.TRUE);
        }

        private boolean isInForStatementBody(PsiExpression expression2, PsiForStatement statement2) {
            PsiStatement body2 = statement2.getBody();
            return body2 != null && PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)expression2, (boolean)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/assignment/AssignmentToForLoopParameterInspectionBase$AssignmentToForLoopParameterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

