/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ShiftOutOfRangeInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.display.name", new Object[0]);
        if (string == null) {
            ShiftOutOfRangeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer value2 = (Integer)infos[0];
        if (value2 > 0) {
            String string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.too.large", new Object[0]);
            if (string == null) {
                ShiftOutOfRangeInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.negative", new Object[0]);
        if (string == null) {
            ShiftOutOfRangeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ShiftOutOfRangeFix((Integer)infos[0], (Boolean)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ShiftOutOfRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bitwise/ShiftOutOfRangeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ShiftOutOfRange
    extends BaseInspectionVisitor {
        private ShiftOutOfRange() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                ShiftOutOfRange.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression2);
            PsiJavaToken sign = expression2.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!(tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT))) {
                return;
            }
            PsiType expressionType = expression2.getType();
            if (expressionType == null) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return;
            }
            Integer valueObject = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)rhs, (PsiType)PsiType.INT);
            if (valueObject == null) {
                return;
            }
            int value2 = valueObject;
            if (expressionType.equals(PsiType.LONG) && (value2 < 0 || value2 > 63)) {
                this.registerError((PsiElement)sign, valueObject, Boolean.TRUE);
            }
            if (expressionType.equals(PsiType.INT) && (value2 < 0 || value2 > 31)) {
                this.registerError((PsiElement)sign, valueObject, Boolean.FALSE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bitwise/ShiftOutOfRangeInspection$ShiftOutOfRange", "visitBinaryExpression"));
        }
    }

    private static class ShiftOutOfRangeFix
    extends InspectionGadgetsFix {
        private final int value;
        private final boolean isLong;

        ShiftOutOfRangeFix(int value2, boolean isLong) {
            this.value = value2;
            this.isLong = isLong;
        }

        @NotNull
        public String getName() {
            int newValue = this.isLong ? this.value & 0x3F : this.value & 0x1F;
            String string = InspectionGadgetsBundle.message("shift.out.of.range.quickfix", this.value, newValue);
            if (string == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Fix shift value" == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(1);
            }
            return "Fix shift value";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression lhs = binaryExpression.getLOperand();
            String text2 = PsiType.LONG.equals((Object)lhs.getType()) ? String.valueOf(this.value & 0x3F) : String.valueOf(this.value & 0x1F);
            PsiExpression newExpression = factory.createExpressionFromText(text2, element);
            rhs.replace((PsiElement)newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bitwise/ShiftOutOfRangeInspection$ShiftOutOfRangeFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

