/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalExpressionInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(ConditionalExpressionInspection.class);
    public boolean ignoreSimpleAssignmentsAndReturns = false;
    public boolean ignoreExpressionContext = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("conditional.expression.display.name", new Object[0]);
        if (string == null) {
            ConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("conditional.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            ConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("conditional.expression.option", new Object[0]), "ignoreSimpleAssignmentsAndReturns");
        panel2.addCheckbox(InspectionGadgetsBundle.message("conditional.expression.expression.context.option", new Object[0]), "ignoreExpressionContext");
        return panel2;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean quickFix = (Boolean)infos[0];
        if (!quickFix) {
            return null;
        }
        return new ReplaceWithIfFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression condition2 = expression2.getCondition();
            PsiElement last = PsiTreeUtil.getDeepestLast((PsiElement)condition2);
            if (last instanceof PsiWhiteSpace) {
                last = last.getPrevSibling();
            }
            if (last instanceof PsiErrorElement) {
                return;
            }
            if (ConditionalExpressionInspection.this.ignoreSimpleAssignmentsAndReturns) {
                PsiElement parent = expression2.getParent();
                while (parent instanceof PsiParenthesizedExpression) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiAssignmentExpression || parent instanceof PsiReturnStatement || parent instanceof PsiLocalVariable || parent instanceof PsiLambdaExpression) {
                    return;
                }
                this.registerError((PsiElement)expression2, ProblemHighlightType.INFORMATION, new Object[]{Boolean.TRUE});
            } else {
                boolean expressionContext = this.isExpressionContext(expression2);
                if (expressionContext && (ConditionalExpressionInspection.this.ignoreExpressionContext || this.isVisibleHighlight((PsiElement)expression2))) {
                    return;
                }
                this.registerError((PsiElement)expression2, !expressionContext);
            }
        }

        private boolean isExpressionContext(PsiConditionalExpression expression2) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class);
            if (member instanceof PsiField) {
                return true;
            }
            if (!(member instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)member;
            if (!method.isConstructor()) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiStatement.class, PsiMember.class});
            return ExpressionUtils.isConstructorInvocation((PsiElement)methodCallExpression);
        }
    }

    private static class ReplaceWithIfFix
    extends InspectionGadgetsFix {
        private ReplaceWithIfFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("conditional.expression.quickfix", new Object[0]);
            if (string == null) {
                ReplaceWithIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) {
            PsiStatement statement2;
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiConditionalExpression)) {
                return;
            }
            PsiConditionalExpression expression2 = (PsiConditionalExpression)element;
            if (!PsiTreeUtil.processElements((PsiElement)expression2, e -> !(e instanceof PsiErrorElement))) {
                return;
            }
            PsiElement expressionParent = expression2.getParent();
            if (expressionParent instanceof PsiLambdaExpression) {
                PsiCodeBlock codeBlock = RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)expressionParent);
                PsiStatement statement3 = codeBlock.getStatements()[0];
                if (statement3 instanceof PsiReturnStatement) {
                    PsiReturnStatement returnStatement = (PsiReturnStatement)statement3;
                    expression2 = (PsiConditionalExpression)returnStatement.getReturnValue();
                } else {
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement3;
                    expression2 = (PsiConditionalExpression)expressionStatement.getExpression();
                }
            }
            if ((statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class)) == null) {
                return;
            }
            PsiVariable variable = statement2 instanceof PsiDeclarationStatement ? (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiVariable.class) : null;
            PsiExpression thenExpression2 = ParenthesesUtils.stripParentheses(expression2.getThenExpression());
            PsiExpression elseExpression2 = ParenthesesUtils.stripParentheses(expression2.getElseExpression());
            PsiExpression condition2 = ParenthesesUtils.stripParentheses(expression2.getCondition());
            StringBuilder newStatement = new StringBuilder();
            newStatement.append("if(");
            if (condition2 != null) {
                newStatement.append(condition2.getText());
            }
            newStatement.append(')');
            if (variable != null) {
                int conditionIdx;
                String name2 = variable.getName();
                newStatement.append(name2).append('=');
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    return;
                }
                if (initializer instanceof PsiArrayInitializerExpression && (conditionIdx = ArrayUtilRt.find((Object[])((PsiArrayInitializerExpression)initializer).getInitializers(), (Object)expression2)) >= 0) {
                    initializer = (PsiExpression)initializer.replace((PsiElement)RefactoringUtil.convertInitializerToNormalExpression(initializer, variable.getType()));
                    PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                    LOG.assertTrue(arrayInitializer != null, (Object)initializer.getText());
                    expression2 = (PsiConditionalExpression)arrayInitializer.getInitializers()[conditionIdx];
                    thenExpression2 = expression2.getThenExpression();
                    elseExpression2 = expression2.getElseExpression();
                }
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression2, thenExpression2, newStatement);
                newStatement.append("; else ").append(name2).append('=');
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression2, elseExpression2, newStatement);
                newStatement.append(';');
                initializer.delete();
                PsiManager manager = statement2.getManager();
                PsiStatement ifStatement = JavaPsiFacade.getElementFactory((Project)project2).createStatementFromText(newStatement.toString(), (PsiElement)statement2);
                PsiElement parent = statement2.getParent();
                PsiElement addedElement = parent.addAfter((PsiElement)ifStatement, (PsiElement)statement2);
                CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)manager.getProject());
                styleManager.reformat(addedElement);
            } else {
                boolean addBraces;
                boolean bl = addBraces = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) != null;
                if (addBraces || thenExpression2 == null) {
                    newStatement.append('{');
                }
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)statement2, (PsiExpression)expression2, thenExpression2, newStatement);
                if (addBraces) {
                    newStatement.append("} else {");
                } else {
                    if (thenExpression2 == null) {
                        newStatement.append('}');
                    }
                    newStatement.append(" else ");
                    if (elseExpression2 == null) {
                        newStatement.append('{');
                    }
                }
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)statement2, (PsiExpression)expression2, elseExpression2, newStatement);
                if (addBraces || elseExpression2 == null) {
                    newStatement.append('}');
                }
                PsiReplacementUtil.replaceStatement(statement2, newStatement.toString());
            }
        }

        private static void appendElementTextWithoutParentheses(@NotNull PsiElement element, @NotNull PsiExpression expressionToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out) {
            PsiElement expressionParent;
            if (element == null) {
                ReplaceWithIfFix.$$$reportNull$$$0(1);
            }
            if (expressionToReplace == null) {
                ReplaceWithIfFix.$$$reportNull$$$0(2);
            }
            if (out == null) {
                ReplaceWithIfFix.$$$reportNull$$$0(3);
            }
            if ((expressionParent = expressionToReplace.getParent()) instanceof PsiParenthesizedExpression) {
                PsiElement grandParent = expressionParent.getParent();
                if (replacementExpression == null || !(grandParent instanceof PsiExpression) || !ParenthesesUtils.areParenthesesNeeded(replacementExpression, (PsiExpression)grandParent, false)) {
                    ReplaceWithIfFix.appendElementTextWithoutParentheses(element, (PsiExpression)expressionParent, replacementExpression, out);
                    return;
                }
            }
            boolean needsCast = replacementExpression != null && MethodCallUtils.isNecessaryForSurroundingMethodCall(expressionToReplace, replacementExpression);
            ReplaceWithIfFix.appendElementText(element, expressionToReplace, replacementExpression, needsCast, out);
        }

        private static void appendElementText(@NotNull PsiElement element, @NotNull PsiExpression elementToReplace, @Nullable PsiExpression replacementExpression, boolean insertCast, @NotNull StringBuilder out) {
            if (element == null) {
                ReplaceWithIfFix.$$$reportNull$$$0(4);
            }
            if (elementToReplace == null) {
                ReplaceWithIfFix.$$$reportNull$$$0(5);
            }
            if (out == null) {
                ReplaceWithIfFix.$$$reportNull$$$0(6);
            }
            if (element.equals(elementToReplace)) {
                String replacementText = replacementExpression == null ? "" : replacementExpression.getText();
                PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)ExpectedTypeUtils.findExpectedType(elementToReplace, true));
                if (insertCast && type2 != null) {
                    out.append('(').append(type2.getCanonicalText()).append(')');
                }
                out.append(replacementText);
                return;
            }
            PsiElement[] children2 = element.getChildren();
            if (children2.length == 0) {
                PsiComment comment;
                IElementType tokenType;
                out.append(element.getText());
                if (element instanceof PsiComment && (tokenType = (comment = (PsiComment)element).getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
                    out.append('\n');
                }
                return;
            }
            for (PsiElement child : children2) {
                ReplaceWithIfFix.appendElementText(child, elementToReplace, replacementExpression, insertCast, out);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ConditionalExpressionInspection$ReplaceWithIfFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionToReplace";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToReplace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ConditionalExpressionInspection$ReplaceWithIfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "appendElementTextWithoutParentheses";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "appendElementText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

