/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementWithConfusingDeclarationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("LocalVariableUsedAndDeclaredInDifferentSwitchBranches" == null) {
            SwitchStatementWithConfusingDeclarationInspection.$$$reportNull$$$0(0);
        }
        return "LocalVariableUsedAndDeclaredInDifferentSwitchBranches";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.with.confusing.declaration.display.name", new Object[0]);
        if (string == null) {
            SwitchStatementWithConfusingDeclarationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("switch.statement.with.confusing.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            SwitchStatementWithConfusingDeclarationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithConfusingDeclarationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SwitchStatementWithConfusingDeclarationVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithConfusingDeclarationVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            PsiCodeBlock body2;
            if (statement2 == null) {
                SwitchStatementWithConfusingDeclarationVisitor.$$$reportNull$$$0(0);
            }
            if ((body2 = statement2.getBody()) == null) {
                return;
            }
            HashSet variablesInPreviousBranches = new HashSet(5);
            HashSet<PsiLocalVariable> variablesInCurrentBranch = new HashSet<PsiLocalVariable>(5);
            PsiStatement[] statements = body2.getStatements();
            LocalVariableAccessVisitor visitor = new LocalVariableAccessVisitor(variablesInPreviousBranches);
            for (PsiStatement child : statements) {
                if (child instanceof PsiDeclarationStatement) {
                    PsiElement[] declaredElements;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)child;
                    for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiLocalVariable)) continue;
                        PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                        variablesInCurrentBranch.add(localVariable);
                    }
                } else if (child instanceof PsiBreakStatement) {
                    variablesInPreviousBranches.addAll(variablesInCurrentBranch);
                    variablesInCurrentBranch.clear();
                }
                child.accept((PsiElementVisitor)visitor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection$SwitchStatementWithConfusingDeclarationVisitor", "visitSwitchStatement"));
        }

        private class LocalVariableAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiLocalVariable> myVariablesInPreviousBranches;

            private LocalVariableAccessVisitor(Set<PsiLocalVariable> variablesInPreviousBranches) {
                this.myVariablesInPreviousBranches = variablesInPreviousBranches;
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    LocalVariableAccessVisitor.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(referenceExpression);
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                if (qualifier != null) {
                    return;
                }
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable accessedVariable = (PsiLocalVariable)element;
                if (this.myVariablesInPreviousBranches.contains(accessedVariable)) {
                    this.myVariablesInPreviousBranches.remove(accessedVariable);
                    SwitchStatementWithConfusingDeclarationVisitor.this.registerVariableError((PsiVariable)accessedVariable, new Object[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection$SwitchStatementWithConfusingDeclarationVisitor$LocalVariableAccessVisitor", "visitReferenceExpression"));
            }
        }
    }
}

