/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeleteUnnecessaryStatementFix
extends InspectionGadgetsFix {
    private final String name;

    public DeleteUnnecessaryStatementFix(@NonNls String name2) {
        this.name = name2;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", this.name);
        if (string == null) {
            DeleteUnnecessaryStatementFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Remove redundant statement" == null) {
            DeleteUnnecessaryStatementFix.$$$reportNull$$$0(1);
        }
        return "Remove redundant statement";
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiElement keywordElement = descriptor2.getPsiElement();
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)keywordElement, PsiStatement.class);
        if (statement2 == null) {
            return;
        }
        DeleteUnnecessaryStatementFix.deleteUnnecessaryStatement(statement2);
    }

    public static void deleteUnnecessaryStatement(PsiStatement statement2) {
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiDoWhileStatement || parent instanceof PsiForeachStatement || parent instanceof PsiForStatement) {
            PsiReplacementUtil.replaceStatement(statement2, "{}");
        } else {
            DeleteUnnecessaryStatementFix.deleteElement((PsiElement)statement2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/DeleteUnnecessaryStatementFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

