/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeParameterExtendsFinalClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.display.name", new Object[0]);
        if (string == null) {
            TypeParameterExtendsFinalClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer problemType = (Integer)infos[1];
        PsiNamedElement namedElement = (PsiNamedElement)infos[0];
        String name2 = namedElement.getName();
        String string = problemType == 1 ? InspectionGadgetsBundle.message("type.parameter.extends.final.class.problem.descriptor1", name2) : InspectionGadgetsBundle.message("type.parameter.extends.final.class.problem.descriptor2", name2);
        if (string == null) {
            TypeParameterExtendsFinalClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TypeParameterExtendsFinalClassFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterExtendsFinalClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TypeParameterExtendsFinalClassVisitor
    extends BaseInspectionVisitor {
        private TypeParameterExtendsFinalClassVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter classParameter) {
            super.visitTypeParameter(classParameter);
            PsiClassType[] extendsListTypes = classParameter.getExtendsListTypes();
            if (extendsListTypes.length < 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            PsiClass aClass = extendsType.resolve();
            if (aClass == null || !aClass.hasModifierProperty("final")) {
                return;
            }
            PsiIdentifier nameIdentifier = classParameter.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerError((PsiElement)nameIdentifier, aClass, 1);
            }
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiType type2 = typeElement.getType();
            if (!(type2 instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            PsiType extendsBound = wildcardType.getExtendsBound();
            if (!(extendsBound instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)extendsBound;
            PsiClass aClass = classType.resolve();
            if (aClass == null || !aClass.hasModifierProperty("final")) {
                return;
            }
            if (aClass.hasTypeParameters() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)typeElement)) {
                PsiType[] parameters2 = classType.getParameters();
                if (parameters2.length == 0) {
                    return;
                }
                for (PsiType parameter2 : parameters2) {
                    if (!(parameter2 instanceof PsiWildcardType)) continue;
                    return;
                }
            }
            if (TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement)) {
                return;
            }
            this.registerError(typeElement.getFirstChild(), aClass, 2);
        }

        private static boolean isWildcardRequired(PsiTypeElement typeElement) {
            PsiElement ancestor = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class, PsiJavaCodeReferenceElement.class, PsiReferenceParameterList.class});
            if (ancestor instanceof PsiParameter) {
                PsiParameter parameter2 = (PsiParameter)ancestor;
                PsiElement scope = parameter2.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)scope;
                    if (MethodUtils.hasSuper(method)) {
                        return true;
                    }
                } else if (scope instanceof PsiForeachStatement) {
                    PsiForeachStatement foreachStatement = (PsiForeachStatement)scope;
                    PsiExpression iteratedValue2 = foreachStatement.getIteratedValue();
                    if (iteratedValue2 == null) {
                        return true;
                    }
                    PsiParameter iterationParameter = foreachStatement.getIterationParameter();
                    return TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, iterationParameter.getTypeElement(), JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2));
                }
            } else if (ancestor instanceof PsiLocalVariable) {
                PsiLocalVariable localVariable = (PsiLocalVariable)ancestor;
                PsiExpression initializer = localVariable.getInitializer();
                return initializer != null && TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, localVariable.getTypeElement(), initializer.getType());
            }
            return false;
        }

        private static boolean isWildcardRequired(PsiTypeElement innerTypeElement, PsiTypeElement completeTypeElement, PsiType rhsType) {
            PsiType lhsType = completeTypeElement.getType();
            if (lhsType.equals(rhsType) || rhsType == null || !TypeConversionUtil.isAssignable((PsiType)lhsType, (PsiType)rhsType)) {
                return true;
            }
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)innerTypeElement, (Object)marker);
            PsiTypeElement copy = (PsiTypeElement)completeTypeElement.copy();
            PsiElement markedElement = PsiTreeUtil.releaseMark((PsiElement)copy, (Object)marker);
            assert (markedElement != null);
            markedElement.replace(markedElement.getLastChild());
            return !TypeConversionUtil.isAssignable((PsiType)copy.getType(), (PsiType)rhsType);
        }
    }

    private static class TypeParameterExtendsFinalClassFix
    extends InspectionGadgetsFix {
        private TypeParameterExtendsFinalClassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.quickfix", new Object[0]);
            if (string == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(@NotNull Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element;
            PsiElement parent;
            if (project2 == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(1);
            }
            if ((parent = (element = descriptor2.getPsiElement()).getParent()) instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                TypeParameterExtendsFinalClassFix.replaceTypeParameterUsagesWithType(typeParameter);
                typeParameter.delete();
            } else if (parent instanceof PsiTypeElement) {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement lastChild = typeElement.getLastChild();
                if (lastChild == null) {
                    return;
                }
                typeElement.replace(lastChild);
            }
        }

        private static void replaceTypeParameterUsagesWithType(PsiTypeParameter typeParameter) {
            PsiClassType[] types = typeParameter.getExtendsList().getReferencedTypes();
            if (types.length < 1) {
                return;
            }
            Project project2 = typeParameter.getProject();
            PsiJavaCodeReferenceElement classReference2 = JavaPsiFacade.getElementFactory((Project)project2).createReferenceElementByType(types[0]);
            Query query = ReferencesSearch.search((PsiElement)typeParameter, (SearchScope)typeParameter.getUseScope());
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                referenceElement.replace((PsiElement)classReference2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

