/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.InspectionGadgetsBundle;

public class TestClassNamingConvention
extends NamingConvention<PsiClass> {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;
    public static final String TEST_CLASS_NAMING_CONVENTION_SHORT_NAME = "JUnitTestClassNamingConvention";

    @Override
    public NamingConventionBean createDefaultBean() {
        return new NamingConventionBean("[A-Z][A-Za-z\\d]*Test", 8, 64, new String[0]);
    }

    @Override
    public boolean isApplicable(PsiClass member) {
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)member);
        return framework != null && framework.isTestClass((PsiElement)member);
    }

    @Override
    public String getShortName() {
        return TEST_CLASS_NAMING_CONVENTION_SHORT_NAME;
    }

    @Override
    public String getElementDescription() {
        return InspectionGadgetsBundle.message("junit.test.class.naming.convention.element.description", new Object[0]);
    }
}

