/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseOfObsoleteAssertInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("usage.of.obsolete.assert.display.name", new Object[0]);
        if (string == null) {
            UseOfObsoleteAssertInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String name2 = (String)infos[0];
        String string = InspectionGadgetsBundle.message("use.of.obsolete.assert.problem.descriptor", name2);
        if (string == null) {
            UseOfObsoleteAssertInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceObsoleteAssertsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfObsoleteAssertVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/UseOfObsoleteAssertInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceObsoleteAssertsFix
    extends InspectionGadgetsFix {
        private ReplaceObsoleteAssertsFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), PsiMethodCallExpression.class);
            if (psiElement == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project2).findClass("org.junit.Assert", GlobalSearchScope.allScope((Project)project2));
            PsiClass oldAssertClass = JavaPsiFacade.getInstance((Project)project2).findClass("junit.framework.Assert", GlobalSearchScope.allScope((Project)project2));
            if (newAssertClass == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)psiElement;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            PsiElement usedImport = qualifierExpression2 instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression2).advancedResolve(true).getCurrentFileResolveScope() : methodExpression.advancedResolve(true).getCurrentFileResolveScope();
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            boolean isImportUnused = ReplaceObsoleteAssertsFix.isImportBecomeUnused(methodCallExpression, usedImport, psiMethod);
            PsiImportStaticStatement staticStatement = null;
            if (qualifierExpression2 == null) {
                staticStatement = ReplaceObsoleteAssertsFix.staticallyImported(oldAssertClass, methodExpression);
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            if (staticStatement == null) {
                methodExpression.setQualifierExpression((PsiExpression)JavaPsiFacade.getElementFactory((Project)project2).createReferenceExpression(newAssertClass));
                if (isImportUnused && usedImport instanceof PsiImportStatementBase) {
                    usedImport.delete();
                }
                styleManager.shortenClassReferences((PsiElement)methodExpression);
            } else if (isImportUnused) {
                PsiJavaCodeReferenceElement importReference2 = staticStatement.getImportReference();
                if (importReference2 != null) {
                    if (staticStatement.isOnDemand()) {
                        importReference2.bindToElement((PsiElement)newAssertClass);
                    } else {
                        PsiElement importQExpression = importReference2.getQualifier();
                        if (importQExpression instanceof PsiJavaCodeReferenceElement) {
                            ((PsiJavaCodeReferenceElement)importQExpression).bindToElement((PsiElement)newAssertClass);
                        }
                    }
                }
            } else {
                methodExpression.setQualifierExpression((PsiExpression)JavaPsiFacade.getElementFactory((Project)project2).createReferenceExpression(newAssertClass));
                styleManager.shortenClassReferences((PsiElement)methodExpression);
            }
        }

        private static boolean isImportBecomeUnused(final PsiMethodCallExpression methodCallExpression, final PsiElement usedImport, final PsiMethod psiMethod) {
            final boolean[] proceed = new boolean[]{true};
            methodCallExpression.getContainingFile().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (proceed[0]) {
                        super.visitElement(element);
                    }
                }

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (expression2 == methodCallExpression) {
                        return;
                    }
                    PsiMethod resolved = expression2.resolveMethod();
                    if (resolved == psiMethod) {
                        proceed[0] = false;
                    } else {
                        PsiElement resolveScope = expression2.getMethodExpression().advancedResolve(false).getCurrentFileResolveScope();
                        if (resolveScope == usedImport) {
                            proceed[0] = false;
                        }
                    }
                }
            });
            return proceed[0];
        }

        @Nullable
        private static PsiImportStaticStatement staticallyImported(PsiClass oldAssertClass, PsiReferenceExpression methodExpression) {
            PsiImportStaticStatement[] statements;
            String referenceName = methodExpression.getReferenceName();
            PsiFile containingFile = methodExpression.getContainingFile();
            if (!(containingFile instanceof PsiJavaFile)) {
                return null;
            }
            PsiImportList importList = ((PsiJavaFile)containingFile).getImportList();
            if (importList == null) {
                return null;
            }
            for (PsiImportStaticStatement statement2 : statements = importList.getImportStaticStatements()) {
                PsiElement qualifier;
                if (oldAssertClass != statement2.resolveTargetClass()) continue;
                String importRefName = statement2.getReferenceName();
                PsiJavaCodeReferenceElement importReference2 = statement2.getImportReference();
                if (importReference2 == null || !(Comparing.strEqual((String)importRefName, (String)referenceName) ? (qualifier = importReference2.getQualifier()) instanceof PsiJavaCodeReferenceElement : importRefName == null)) continue;
                return statement2;
            }
            return null;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("use.of.obsolete.assert.quickfix", new Object[0]);
            if (string == null) {
                ReplaceObsoleteAssertsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/UseOfObsoleteAssertInspection$ReplaceObsoleteAssertsFix", "getFamilyName"));
        }
    }

    private static class UseOfObsoleteAssertVisitor
    extends BaseInspectionVisitor {
        private UseOfObsoleteAssertVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            Project project2 = expression2.getProject();
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression2);
            if (module2 == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project2).findClass("org.junit.Assert", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2));
            if (newAssertClass == null) {
                return;
            }
            PsiMethod psiMethod = expression2.resolveMethod();
            if (psiMethod == null || !psiMethod.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name2 = containingClass.getQualifiedName();
            if ("junit.framework.Assert".equals(name2) || "junit.framework.TestCase".equals(name2)) {
                this.registerMethodCallError(expression2, name2);
            }
        }
    }
}

