/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigDecimalLegacyMethodInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bigdecimal.legacy.method.display.name", new Object[0]);
        if (string == null) {
            BigDecimalLegacyMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bigdecimal.legacy.method.problem.descriptor", new Object[0]);
        if (string == null) {
            BigDecimalLegacyMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        if (!(value2 instanceof Integer)) {
            return null;
        }
        int roundingMode = (Integer)value2;
        if (roundingMode < 0 || roundingMode > 7) {
            return null;
        }
        return new BigDecimalLegacyMethodFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalLegacyMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/BigDecimalLegacyMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BigDecimalLegacyMethodVisitor
    extends BaseInspectionVisitor {
        private BigDecimalLegacyMethodVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if (!"setScale".equals(name2) && !"divide".equals(name2)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (PsiUtilCore.hasErrorElementChild((PsiElement)argumentList)) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 2 && arguments.length != 3) {
                return;
            }
            PsiExpression argument = arguments[arguments.length - 1];
            if (!PsiType.INT.equals((Object)argument.getType())) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.math.BigDecimal")) {
                return;
            }
            this.registerMethodCallError(expression2, argument);
        }
    }

    private static class BigDecimalLegacyMethodFix
    extends InspectionGadgetsFix {
        private BigDecimalLegacyMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("bigdecimal.legacy.method.quickfix", new Object[0]);
            if (string == null) {
                BigDecimalLegacyMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement grandParent = element.getParent().getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 2 && arguments.length != 3) {
                return;
            }
            PsiExpression argument = arguments[arguments.length - 1];
            Object value2 = ExpressionUtils.computeConstantExpression(argument);
            if (!(value2 instanceof Integer)) {
                return;
            }
            int roundingMode = (Integer)value2;
            switch (roundingMode) {
                case 0: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.UP");
                    break;
                }
                case 1: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.DOWN");
                    break;
                }
                case 2: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.CEILING");
                    break;
                }
                case 3: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.FLOOR");
                    break;
                }
                case 4: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.HALF_UP");
                    break;
                }
                case 5: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.HALF_DOWN");
                    break;
                }
                case 6: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.HALF_EVEN");
                    break;
                }
                case 7: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.UNNECESSARY");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/BigDecimalLegacyMethodInspection$BigDecimalLegacyMethodFix", "getFamilyName"));
        }
    }
}

