/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IntLiteralMayBeLongLiteralInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.display.name", new Object[0]);
        if (string == null) {
            IntLiteralMayBeLongLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = IntLiteralMayBeLongLiteralInspection.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.problem.descriptor", replacementText);
        if (string == null) {
            IntLiteralMayBeLongLiteralInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = IntLiteralMayBeLongLiteralInspection.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        return new IntLiteralMayBeLongLiteralFix(replacementText.toString());
    }

    private static StringBuilder buildReplacementText(PsiExpression expression2, StringBuilder out) {
        if (expression2 instanceof PsiLiteralExpression) {
            out.append(expression2.getText());
            out.append('L');
        } else {
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiJavaToken sign = prefixExpression.getOperationSign();
                out.append(sign.getText());
                return IntLiteralMayBeLongLiteralInspection.buildReplacementText(prefixExpression.getOperand(), out);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                out.append('(');
                IntLiteralMayBeLongLiteralInspection.buildReplacementText(parenthesizedExpression.getExpression(), out);
                out.append(')');
            } else if (expression2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
                PsiExpression operand2 = typeCastExpression.getOperand();
                IntLiteralMayBeLongLiteralInspection.buildReplacementText(operand2, out);
            } else assert (false);
        }
        return out;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntLiteralMayBeLongLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/IntLiteralMayBeLongLiteralInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IntLiteralMayBeLongLiteralVisitor
    extends BaseInspectionVisitor {
        private IntLiteralMayBeLongLiteralVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!PsiType.INT.equals((Object)type2)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiPrefixExpression || parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiType castType = typeCastExpression.getType();
            if (!PsiType.LONG.equals((Object)castType)) {
                return;
            }
            this.registerError((PsiElement)typeCastExpression, typeCastExpression);
        }
    }

    private static class IntLiteralMayBeLongLiteralFix
    extends InspectionGadgetsFix {
        private final String replacementString;

        public IntLiteralMayBeLongLiteralFix(String replacementString) {
            this.replacementString = replacementString;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.quickfix", this.replacementString);
            if (string == null) {
                IntLiteralMayBeLongLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with long literal" == null) {
                IntLiteralMayBeLongLiteralFix.$$$reportNull$$$0(1);
            }
            return "Replace with long literal";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, this.replacementString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/numeric/IntLiteralMayBeLongLiteralInspection$IntLiteralMayBeLongLiteralFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

