/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryCallToStringValueOfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.call.to.string.valueof.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text2 = (String)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessary.call.to.string.valueof.problem.descriptor", text2);
        if (string == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String text2 = (String)infos[0];
        return new UnnecessaryCallToStringValueOfFix(text2);
    }

    public static String calculateReplacementText(PsiExpression expression2) {
        if (!(expression2 instanceof PsiPolyadicExpression)) {
            return expression2.getText();
        }
        PsiType type2 = expression2.getType();
        if (TypeUtils.typeEquals("java.lang.String", type2) || ParenthesesUtils.getPrecedence(expression2) < 6) {
            return expression2.getText();
        }
        return '(' + expression2.getText() + ')';
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryCallToStringValueOfVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryCallToStringValueOfVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryCallToStringValueOfVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiMethodCallExpression methodCallExpression;
            boolean throwable;
            PsiArrayType arrayType;
            PsiType componentType;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = ParenthesesUtils.stripParentheses(arguments[0]);
            if (argument == null) {
                return;
            }
            PsiType argumentType = argument.getType();
            if (argumentType instanceof PsiArrayType && PsiType.CHAR.equals((Object)(componentType = (arrayType = (PsiArrayType)argumentType).getComponentType()))) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (!"java.lang.String".equals(qualifiedName)) {
                return;
            }
            if (!TypeUtils.isJavaLangString(argumentType) && ExpressionUtils.isConversionToStringNecessary((PsiExpression)expression2, throwable = TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable"))) {
                return;
            }
            if (argument instanceof PsiReferenceExpression ? UnnecessaryCallToStringValueOfVisitor.couldChangeSemantics((PsiReferenceExpression)argument) : argument instanceof PsiMethodCallExpression && UnnecessaryCallToStringValueOfVisitor.couldChangeSemantics((methodCallExpression = (PsiMethodCallExpression)argument).getMethodExpression())) {
                return;
            }
            this.registerError((PsiElement)expression2, UnnecessaryCallToStringValueOfInspection.calculateReplacementText(argument));
        }

        private static boolean couldChangeSemantics(PsiReferenceExpression referenceExpression) {
            PsiElement target2 = referenceExpression.resolve();
            return !(target2 instanceof PsiModifierListOwner) || !NullableNotNullManager.isNotNull((PsiModifierListOwner)((PsiModifierListOwner)target2));
        }
    }

    private static class UnnecessaryCallToStringValueOfFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        UnnecessaryCallToStringValueOfFix(String replacementText) {
            this.replacementText = replacementText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.call.to.string.valueof.quickfix", this.replacementText);
            if (string == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)descriptor2.getPsiElement();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, UnnecessaryCallToStringValueOfInspection.calculateReplacementText(arguments[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection$UnnecessaryCallToStringValueOfFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

