/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.enumswitch;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.enumswitch.EnumSwitchPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CreateEnumSwitchBranchesIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        EnumSwitchPredicate enumSwitchPredicate = new EnumSwitchPredicate();
        if (enumSwitchPredicate == null) {
            CreateEnumSwitchBranchesIntention.$$$reportNull$$$0(0);
        }
        return enumSwitchPredicate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiStatement[] statements;
        if (element == null) {
            CreateEnumSwitchBranchesIntention.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
            assert (element != null);
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)element;
        PsiCodeBlock body2 = switchStatement.getBody();
        PsiExpression switchExpression = switchStatement.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiClassType switchType = (PsiClassType)switchExpression.getType();
        if (switchType == null) {
            return;
        }
        PsiClass enumClass = switchType.resolve();
        if (enumClass == null) {
            return;
        }
        PsiField[] fields = enumClass.getFields();
        ArrayList<PsiEnumConstant> missingEnumElements = new ArrayList<PsiEnumConstant>(fields.length);
        for (PsiField psiField : fields) {
            if (!(psiField instanceof PsiEnumConstant)) continue;
            PsiEnumConstant enumConstant = (PsiEnumConstant)psiField;
            missingEnumElements.add(enumConstant);
        }
        if (body2 == null) {
            StringBuilder newStatementText = new StringBuilder();
            newStatementText.append("switch(").append(switchExpression.getText()).append("){");
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                newStatementText.append("case ").append(missingEnumElement.getName()).append(": break;");
            }
            newStatementText.append('}');
            PsiReplacementUtil.replaceStatement((PsiStatement)switchStatement, newStatementText.toString());
            return;
        }
        HashMap<PsiEnumConstant, PsiEnumConstant> nextEnumConstants = new HashMap<PsiEnumConstant, PsiEnumConstant>(fields.length);
        PsiEnumConstant previous = null;
        for (PsiEnumConstant psiEnumConstant : missingEnumElements) {
            if (previous != null) {
                nextEnumConstants.put(previous, psiEnumConstant);
            }
            previous = psiEnumConstant;
        }
        for (PsiStatement statement2 : statements = body2.getStatements()) {
            missingEnumElements.remove(CreateEnumSwitchBranchesIntention.findEnumConstant((PsiElement)statement2));
        }
        PsiEnumConstant psiEnumConstant = CreateEnumSwitchBranchesIntention.getNextEnumConstant(nextEnumConstants, missingEnumElements);
        for (PsiElement bodyElement = body2.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
            void var12_21;
            while (var12_21 != null && CreateEnumSwitchBranchesIntention.findEnumConstant(bodyElement) == var12_21) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore((PsiEnumConstant)missingEnumElements.get(0), bodyElement);
                missingEnumElements.remove(0);
                if (missingEnumElements.isEmpty()) break;
                PsiEnumConstant psiEnumConstant2 = CreateEnumSwitchBranchesIntention.getNextEnumConstant(nextEnumConstants, missingEnumElements);
            }
            if (!CreateEnumSwitchBranchesIntention.isDefaultSwitchLabelStatement(bodyElement)) continue;
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore(missingEnumElement, bodyElement);
            }
            missingEnumElements.clear();
            break;
        }
        if (!missingEnumElements.isEmpty()) {
            PsiElement lastChild = body2.getLastChild();
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore(missingEnumElement, lastChild);
            }
        }
    }

    private static void addSwitchLabelStatementBefore(PsiEnumConstant missingEnumElement, PsiElement anchor) {
        if (anchor instanceof PsiSwitchLabelStatement) {
            PsiElement sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
            while (sibling instanceof PsiSwitchLabelStatement) {
                anchor = sibling;
                sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
            }
        }
        PsiElement parent = anchor.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
        PsiStatement caseStatement = factory.createStatementFromText("case " + missingEnumElement.getName() + ":", anchor);
        parent.addBefore((PsiElement)caseStatement, anchor);
        PsiStatement breakStatement = factory.createStatementFromText("break;", anchor);
        parent.addBefore((PsiElement)breakStatement, anchor);
    }

    private static PsiEnumConstant findEnumConstant(PsiElement element) {
        if (!(element instanceof PsiSwitchLabelStatement)) {
            return null;
        }
        PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)element;
        PsiExpression value2 = switchLabelStatement.getCaseValue();
        if (!(value2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value2;
        PsiElement target2 = referenceExpression.resolve();
        if (!(target2 instanceof PsiEnumConstant)) {
            return null;
        }
        return (PsiEnumConstant)target2;
    }

    private static PsiEnumConstant getNextEnumConstant(Map<PsiEnumConstant, PsiEnumConstant> nextEnumConstants, List<PsiEnumConstant> missingEnumElements) {
        PsiEnumConstant nextEnumConstant = nextEnumConstants.get(missingEnumElements.get(0));
        while (missingEnumElements.contains(nextEnumConstant)) {
            nextEnumConstant = nextEnumConstants.get(nextEnumConstant);
        }
        return nextEnumConstant;
    }

    private static boolean isDefaultSwitchLabelStatement(PsiElement element) {
        if (!(element instanceof PsiSwitchLabelStatement)) {
            return false;
        }
        PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)element;
        return switchLabelStatement.isDefaultCase();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/enumswitch/CreateEnumSwitchBranchesIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/enumswitch/CreateEnumSwitchBranchesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

