/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ConvertCatchToThrowsPredicate;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertCatchToThrowsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertCatchToThrowsPredicate convertCatchToThrowsPredicate = new ConvertCatchToThrowsPredicate();
        if (convertCatchToThrowsPredicate == null) {
            ConvertCatchToThrowsIntention.$$$reportNull$$$0(0);
        }
        return convertCatchToThrowsPredicate;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethod method;
        PsiCatchSection catchSection;
        NavigatablePsiElement owner2;
        if (element == null) {
            ConvertCatchToThrowsIntention.$$$reportNull$$$0(1);
        }
        if ((owner2 = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)(catchSection = (PsiCatchSection)element.getParent()), (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class})) instanceof PsiMethod) {
            method = (PsiMethod)owner2;
        } else if (owner2 instanceof PsiLambdaExpression) {
            method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)owner2);
        } else {
            return;
        }
        if (method == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
            return;
        }
        WriteAction.run(() -> {
            PsiReferenceList throwsList = method.getThrowsList();
            PsiType catchType = catchSection.getCatchType();
            ConvertCatchToThrowsIntention.addToThrowsList(throwsList, catchType);
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            if (catchSections.length > 1 || tryStatement.getResourceList() != null || tryStatement.getFinallyBlock() != null) {
                catchSection.delete();
            } else {
                PsiCodeBlock tryBlock = tryStatement.getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                PsiCodeBlock parentCodeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiCodeBlock.class);
                if (parentCodeBlock == null || !DeclarationSearchUtils.containsConflictingDeclarations(tryBlock, parentCodeBlock)) {
                    PsiElement first = tryBlock.getFirstBodyElement();
                    PsiElement last = tryBlock.getLastBodyElement();
                    if (first != null && last != null) {
                        tryStatement.getParent().addRangeAfter(first, last, (PsiElement)tryStatement);
                    }
                    tryStatement.delete();
                } else {
                    tryStatement.replace((PsiElement)tryBlock);
                }
            }
        });
    }

    private static void addToThrowsList(PsiReferenceList throwsList, PsiType catchType) {
        if (catchType instanceof PsiClassType) {
            PsiClassType[] types;
            PsiClassType classType = (PsiClassType)catchType;
            for (PsiClassType type2 : types = throwsList.getReferencedTypes()) {
                if (!catchType.equals(type2)) continue;
                return;
            }
            Project project2 = throwsList.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
            throwsList.add((PsiElement)referenceElement);
        } else if (catchType instanceof PsiDisjunctionType) {
            PsiDisjunctionType disjunctionType = (PsiDisjunctionType)catchType;
            List disjunctions = disjunctionType.getDisjunctions();
            for (PsiType disjunction : disjunctions) {
                ConvertCatchToThrowsIntention.addToThrowsList(throwsList, disjunction);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/exceptions/ConvertCatchToThrowsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/exceptions/ConvertCatchToThrowsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

