/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import icons.ImagesIcons;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.search.TagFilter;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.intellij.images.thumbnail.impl.ThumbnailViewUI;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ThumbnailViewImpl
implements ThumbnailView {
    private final Project project;
    private final ToolWindow toolWindow;
    private boolean recursive = false;
    private VirtualFile root = null;
    private final ThumbnailViewUI myThubmnailViewUi;
    private ThemeFilter myFilter;
    private TagFilter[] myTagFilters;

    public ThumbnailViewImpl(Project project2) {
        this.project = project2;
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        this.myThubmnailViewUi = new ThumbnailViewUI(this);
        this.toolWindow = windowManager.registerToolWindow(TOOLWINDOW_ID, (JComponent)this.myThubmnailViewUi, ToolWindowAnchor.BOTTOM);
        this.toolWindow.setIcon(ImagesIcons.ThumbnailToolWindow);
        this.setVisible(false);
    }

    private ThumbnailViewUI getUI() {
        return this.myThubmnailViewUi;
    }

    @Override
    public void setRoot(@NotNull VirtualFile root) {
        if (root == null) {
            ThumbnailViewImpl.$$$reportNull$$$0(0);
        }
        this.root = root;
        this.updateUI();
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
        this.updateUI();
    }

    @Override
    public void setSelected(@NotNull VirtualFile file2, boolean selected) {
        if (file2 == null) {
            ThumbnailViewImpl.$$$reportNull$$$0(1);
        }
        if (this.isVisible()) {
            this.getUI().setSelected(file2, selected);
        }
    }

    @Override
    public boolean isSelected(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ThumbnailViewImpl.$$$reportNull$$$0(2);
        }
        return this.isVisible() && this.getUI().isSelected(file2);
    }

    @Override
    @NotNull
    public VirtualFile[] getSelection() {
        if (this.isVisible()) {
            VirtualFile[] virtualFileArray = this.getUI().getSelection();
            if (virtualFileArray == null) {
                ThumbnailViewImpl.$$$reportNull$$$0(3);
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            ThumbnailViewImpl.$$$reportNull$$$0(4);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    public void scrollToSelection() {
        if (this.isVisible()) {
            if (!this.toolWindow.isActive()) {
                this.toolWindow.activate((Runnable)new LazyScroller());
            } else {
                this.getUI().scrollToSelection();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.toolWindow.isAvailable();
    }

    @Override
    public void activate() {
        if (this.isVisible() && !this.toolWindow.isActive()) {
            this.toolWindow.activate(null);
        }
    }

    @Override
    public void setFilter(ThemeFilter filter2) {
        this.myFilter = filter2;
        this.updateUI();
    }

    @Override
    public ThemeFilter getFilter() {
        return this.myFilter;
    }

    @Override
    public void setTagFilters(TagFilter[] filter2) {
        this.myTagFilters = filter2;
        this.updateUI();
    }

    @Override
    @Nullable
    public TagFilter[] getTagFilters() {
        return this.myTagFilters;
    }

    @Override
    public void setVisible(boolean visible) {
        this.toolWindow.setAvailable(visible, null);
        if (visible) {
            this.setTitle();
            this.getUI().refresh();
        } else {
            this.getUI().dispose();
        }
    }

    @Override
    public void refresh() {
        this.updateUI();
    }

    private void updateUI() {
        if (this.isVisible()) {
            this.setTitle();
            this.getUI().refresh();
        }
    }

    private void setTitle() {
        this.toolWindow.setTitle(this.root != null ? IfsUtil.getReferencePath(this.project, this.root) : null);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.project;
        if (project2 == null) {
            ThumbnailViewImpl.$$$reportNull$$$0(5);
        }
        return project2;
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        if (this.isVisible()) {
            this.getUI().setTransparencyChessboardVisible(visible);
        }
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.isVisible() && this.getUI().isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return this.isVisible() && !"Images.Editor".equals(place);
    }

    @Override
    public boolean isFileSizeVisible() {
        return this.isVisible() && this.getUI().isFileSizeVisible();
    }

    @Override
    public void setFileSizeVisible(boolean visible) {
        if (this.isVisible()) {
            this.getUI().setFileSizeVisible(visible);
        }
    }

    @Override
    public boolean isFileNameVisible() {
        return this.isVisible() && this.getUI().isFileNameVisible();
    }

    @Override
    public void setFileNameVisible(boolean visible) {
        if (this.isVisible()) {
            this.getUI().setFileNameVisible(visible);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.getUI());
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.project);
        windowManager.unregisterToolWindow(TOOLWINDOW_ID);
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return ImageZoomModel.STUB;
    }

    @Override
    public void setGridVisible(boolean visible) {
    }

    @Override
    public boolean isGridVisible() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/thumbnail/impl/ThumbnailViewImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/thumbnail/impl/ThumbnailViewImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class LazyScroller
    implements Runnable {
        private LazyScroller() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(() -> ThumbnailViewImpl.this.getUI().scrollToSelection());
        }
    }
}

