/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpParser
implements PsiParser,
LightPsiParser {
    private static final TokenSet PROPERTY_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.NUMBER, RegExpTT.COMMA, RegExpTT.NAME, RegExpTT.RBRACE});
    private final EnumSet<RegExpCapability> myCapabilities;

    public RegExpParser(EnumSet<RegExpCapability> capabilities) {
        this.myCapabilities = capabilities;
    }

    public void parseLight(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        this.parsePattern(builder);
        while (!builder.eof()) {
            RegExpParser.patternExpected(builder);
            builder.advanceLexer();
        }
        rootMarker.done(root);
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            RegExpParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            RegExpParser.$$$reportNull$$$0(1);
        }
        this.parseLight(root, builder);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            RegExpParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    private boolean parsePattern(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseBranch(builder)) {
            marker.drop();
            return false;
        }
        while (builder.getTokenType() == RegExpTT.UNION) {
            builder.advanceLexer();
            if (this.parseBranch(builder)) continue;
            RegExpParser.patternExpected(builder);
            break;
        }
        marker.done(RegExpElementTypes.PATTERN);
        return true;
    }

    private boolean parseBranch(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseAtom(builder)) {
            IElementType token = builder.getTokenType();
            if (token == RegExpTT.GROUP_END || token == RegExpTT.UNION || token == null) {
                marker.done(RegExpElementTypes.BRANCH);
                return true;
            }
            marker.drop();
            return false;
        }
        while (this.parseAtom(builder)) {
        }
        marker.done(RegExpElementTypes.BRANCH);
        return true;
    }

    private boolean parseAtom(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseGroup(builder);
        if (marker == null) {
            return false;
        }
        PsiBuilder.Marker marker2 = marker.precede();
        if (this.parseQuantifier(builder)) {
            marker2.done(RegExpElementTypes.CLOSURE);
        } else {
            marker2.drop();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseQuantifier(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() == RegExpTT.LBRACE) {
            PsiBuilder.Marker numberMark;
            boolean minOmitted;
            builder.advanceLexer();
            boolean bl = minOmitted = builder.getTokenType() == RegExpTT.COMMA && this.myCapabilities.contains((Object)RegExpCapability.OMIT_NUMBERS_IN_QUANTIFIERS);
            if (minOmitted) {
                builder.advanceLexer();
            } else if (builder.getTokenType() == RegExpTT.NUMBER) {
                numberMark = builder.mark();
                builder.advanceLexer();
                numberMark.done(RegExpElementTypes.NUMBER);
            } else {
                builder.error("Number expected");
            }
            if (builder.getTokenType() == RegExpTT.RBRACE) {
                builder.advanceLexer();
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (!minOmitted) {
                RegExpParser.checkMatches(builder, RegExpTT.COMMA, "',' expected");
            }
            if (builder.getTokenType() == RegExpTT.RBRACE) {
                builder.advanceLexer();
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (builder.getTokenType() == RegExpTT.NUMBER) {
                numberMark = builder.mark();
                builder.advanceLexer();
                numberMark.done(RegExpElementTypes.NUMBER);
                RegExpParser.checkMatches(builder, RegExpTT.RBRACE, "'}' expected");
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            builder.error("'}' or number expected");
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        if (RegExpTT.QUANTIFIERS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            RegExpParser.parseQuantifierType(builder);
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        marker.drop();
        return false;
    }

    private static void parseQuantifierType(PsiBuilder builder) {
        if (builder.getTokenType() == RegExpTT.PLUS || builder.getTokenType() == RegExpTT.QUEST) {
            builder.advanceLexer();
        } else if (RegExpTT.QUANTIFIERS.contains(builder.getTokenType())) {
            builder.error("Dangling metacharacter");
        }
    }

    private PsiBuilder.Marker parseClass(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.CARET) {
            builder.advanceLexer();
        }
        this.parseClassIntersection(builder);
        RegExpParser.checkMatches(builder, RegExpTT.CLASS_END, "Unclosed character class");
        marker.done(RegExpElementTypes.CLASS);
        return marker;
    }

    private void parseClassIntersection(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        boolean left = this.parseClassdef(builder);
        if (RegExpTT.ANDAND != builder.getTokenType()) {
            marker.drop();
            return;
        }
        while (RegExpTT.ANDAND == builder.getTokenType()) {
            builder.advanceLexer();
            boolean right = this.parseClassdef(builder);
            if (!left && !right) {
                builder.error("character class expected");
            }
            left = right;
        }
        marker.done(RegExpElementTypes.INTERSECTION);
    }

    private boolean parseClassdef(PsiBuilder builder) {
        int count = 0;
        while (true) {
            IElementType token;
            if ((token = builder.getTokenType()) == RegExpTT.CLASS_BEGIN) {
                this.parseClass(builder);
            } else if (token == RegExpTT.BRACKET_EXPRESSION_BEGIN) {
                RegExpParser.parseBracketExpression(builder);
            } else if (token == RegExpTT.MYSQL_CHAR_BEGIN) {
                RegExpParser.parseMysqlCharExpression(builder);
            } else if (token == RegExpTT.MYSQL_CHAR_EQ_BEGIN) {
                RegExpParser.parseMysqlCharEqExpression(builder);
            } else if (RegExpTT.CHARACTERS.contains(token) || token == RegExpTT.NAMED_CHARACTER) {
                this.parseCharacterRange(builder);
            } else if (token == RegExpTT.CHAR_CLASS) {
                PsiBuilder.Marker m = builder.mark();
                builder.advanceLexer();
                m.done(RegExpElementTypes.SIMPLE_CLASS);
            } else if (token == RegExpTT.PROPERTY) {
                this.parseProperty(builder);
            } else {
                return count > 0;
            }
            ++count;
        }
    }

    private static void parseBracketExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.CARET) {
            builder.advanceLexer();
        }
        RegExpParser.checkMatches(builder, RegExpTT.NAME, "POSIX character class name expected");
        RegExpParser.checkMatches(builder, RegExpTT.BRACKET_EXPRESSION_END, "Unclosed POSIX bracket expression");
        marker.done(RegExpElementTypes.POSIX_BRACKET_EXPRESSION);
    }

    private static void parseMysqlCharExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.NAME) {
            builder.advanceLexer();
        } else {
            RegExpParser.checkMatches(builder, RegExpTT.CHARACTER, "Character or MySQL character name expected");
        }
        RegExpParser.checkMatches(builder, RegExpTT.MYSQL_CHAR_END, "Unclosed MySQL character expression");
        marker.done(RegExpElementTypes.MYSQL_CHAR_EXPRESSION);
    }

    private static void parseMysqlCharEqExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        RegExpParser.checkMatches(builder, RegExpTT.CHARACTER, "Character expected");
        RegExpParser.checkMatches(builder, RegExpTT.MYSQL_CHAR_EQ_END, "Unclosed MySQL character equivalence class");
        marker.done(RegExpElementTypes.MYSQL_CHAR_EQ_EXPRESSION);
    }

    private void parseCharacterRange(PsiBuilder builder) {
        PsiBuilder.Marker rangeMarker = builder.mark();
        RegExpParser.parseCharacter(builder);
        if (builder.getTokenType() == RegExpTT.MINUS) {
            PsiBuilder.Marker minusMarker = builder.mark();
            builder.advanceLexer();
            IElementType t = builder.getTokenType();
            if (RegExpTT.CHARACTERS.contains(t) || t == RegExpTT.NAMED_CHARACTER) {
                minusMarker.drop();
                RegExpParser.parseCharacter(builder);
                rangeMarker.done(RegExpElementTypes.CHAR_RANGE);
            } else if (t == RegExpTT.CLASS_END) {
                rangeMarker.drop();
                minusMarker.done(RegExpElementTypes.CHAR);
            } else if (t == RegExpTT.CLASS_BEGIN) {
                rangeMarker.drop();
                minusMarker.done(RegExpElementTypes.CHAR);
                this.parseClassdef(builder);
            } else {
                minusMarker.drop();
                builder.error("Illegal character range");
                rangeMarker.done(RegExpElementTypes.CHAR_RANGE);
            }
        } else {
            rangeMarker.drop();
        }
    }

    @Nullable
    private PsiBuilder.Marker parseGroup(PsiBuilder builder) {
        IElementType type2 = builder.getTokenType();
        PsiBuilder.Marker marker = builder.mark();
        if (RegExpTT.GROUPS.contains(type2)) {
            builder.advanceLexer();
            this.parseGroupEnd(builder);
            marker.done(RegExpElementTypes.GROUP);
        } else if (type2 == RegExpTT.SET_OPTIONS) {
            PsiBuilder.Marker o;
            builder.advanceLexer();
            if (builder.getTokenType() == RegExpTT.OPTIONS_ON) {
                o = builder.mark();
                builder.advanceLexer();
                o.done(RegExpElementTypes.OPTIONS);
            }
            if (builder.getTokenType() == RegExpTT.OPTIONS_OFF) {
                o = builder.mark();
                builder.advanceLexer();
                o.done(RegExpElementTypes.OPTIONS);
            }
            if (builder.getTokenType() == RegExpTT.COLON) {
                builder.advanceLexer();
                this.parseGroupEnd(builder);
                marker.done(RegExpElementTypes.GROUP);
            } else {
                RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed options group");
                marker.done(RegExpElementTypes.SET_OPTIONS);
            }
        } else if (RegExpTT.CHARACTERS.contains(type2) || type2 == RegExpTT.NAMED_CHARACTER) {
            marker.drop();
            RegExpParser.parseCharacter(builder);
        } else if (RegExpTT.BOUNDARIES.contains(type2)) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.BOUNDARY);
        } else if (type2 == RegExpTT.BACKREF) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.BACKREF);
        } else if (type2 == RegExpTT.PYTHON_NAMED_GROUP || type2 == RegExpTT.RUBY_NAMED_GROUP || type2 == RegExpTT.RUBY_QUOTED_NAMED_GROUP) {
            builder.advanceLexer();
            RegExpParser.checkMatches(builder, RegExpTT.NAME, "Group name expected");
            RegExpParser.checkMatches(builder, type2 == RegExpTT.RUBY_QUOTED_NAMED_GROUP ? RegExpTT.QUOTE : RegExpTT.GT, "Unclosed group name");
            this.parseGroupEnd(builder);
            marker.done(RegExpElementTypes.GROUP);
        } else if (type2 == RegExpTT.PYTHON_NAMED_GROUP_REF) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.GROUP_END);
        } else if (type2 == RegExpTT.RUBY_NAMED_GROUP_REF || type2 == RegExpTT.RUBY_NAMED_GROUP_CALL) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.GT);
        } else if (type2 == RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF || type2 == RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.QUOTE);
        } else if (type2 == RegExpTT.PYTHON_COND_REF) {
            builder.advanceLexer();
            if (builder.getTokenType() == RegExpTT.NAME || builder.getTokenType() == RegExpTT.NUMBER) {
                builder.advanceLexer();
            } else {
                builder.error("Group name or number expected");
            }
            RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group reference");
            if (!this.parseBranch(builder)) {
                RegExpParser.patternExpected(builder);
            } else {
                if (builder.getTokenType() == RegExpTT.UNION) {
                    builder.advanceLexer();
                    if (!this.parseBranch(builder)) {
                        RegExpParser.patternExpected(builder);
                    }
                }
                RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group");
            }
            marker.done(RegExpElementTypes.PY_COND_REF);
        } else if (type2 == RegExpTT.PROPERTY) {
            marker.drop();
            this.parseProperty(builder);
        } else if (type2 == RegExpTT.DOT || type2 == RegExpTT.CHAR_CLASS) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.SIMPLE_CLASS);
        } else {
            if (type2 == RegExpTT.CLASS_BEGIN) {
                marker.drop();
                return this.parseClass(builder);
            }
            marker.drop();
            return null;
        }
        return marker;
    }

    private void parseGroupEnd(PsiBuilder builder) {
        if (!this.parsePattern(builder)) {
            RegExpParser.patternExpected(builder);
        } else {
            RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group");
        }
    }

    private static void parseNamedGroupRef(PsiBuilder builder, PsiBuilder.Marker marker, IElementType type2) {
        builder.advanceLexer();
        RegExpParser.checkMatches(builder, RegExpTT.NAME, "Group name expected");
        RegExpParser.checkMatches(builder, type2, "Unclosed group reference");
        marker.done(RegExpElementTypes.NAMED_GROUP_REF);
    }

    private static boolean isLetter(CharSequence text2) {
        assert (text2.length() == 1);
        char c = text2.charAt(0);
        return AsciiUtil.isLetter(c);
    }

    private void parseProperty(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.CATEGORY_SHORT_HAND) {
            if (!this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND)) {
                builder.error("Category shorthand not allowed in this regular expression dialect");
            }
            builder.advanceLexer();
        } else if (builder.getTokenType() == RegExpTT.CHARACTER && RegExpParser.isLetter(builder.getTokenText())) {
            builder.error(this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND) ? "Illegal category shorthand" : "'{' expected");
            builder.advanceLexer();
        } else if (RegExpParser.checkMatches(builder, RegExpTT.LBRACE, this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND) ? "'{' or category shorthand expected" : "'{' expected")) {
            if (builder.getTokenType() == RegExpTT.CARET) {
                if (!this.myCapabilities.contains((Object)RegExpCapability.CARET_NEGATED_PROPERTIES)) {
                    builder.error("Negating a property not allowed in this regular expression dialect");
                }
                builder.advanceLexer();
            }
            if (builder.getTokenType() == RegExpTT.NAME) {
                builder.advanceLexer();
                RegExpParser.checkMatches(builder, RegExpTT.RBRACE, "Unclosed property");
            } else {
                if (builder.getTokenType() == RegExpTT.RBRACE) {
                    builder.error("Empty property");
                    builder.advanceLexer();
                } else {
                    builder.error("Property name expected");
                }
                while (PROPERTY_TOKENS.contains(builder.getTokenType())) {
                    builder.advanceLexer();
                }
            }
        }
        marker.done(RegExpElementTypes.PROPERTY);
    }

    private static void parseCharacter(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() == RegExpTT.NAMED_CHARACTER) {
            builder.advanceLexer();
            RegExpParser.checkMatches(builder, RegExpTT.LBRACE, "'{' expected");
            RegExpParser.checkMatches(builder, RegExpTT.NAME, "Unicode character name expected");
            RegExpParser.checkMatches(builder, RegExpTT.RBRACE, "'}' expected");
            marker.done(RegExpElementTypes.NAMED_CHARACTER);
        } else {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.CHAR);
        }
    }

    private static void patternExpected(PsiBuilder builder) {
        IElementType token = builder.getTokenType();
        if (token == RegExpTT.GROUP_END) {
            builder.error("Unmatched closing ')'");
        } else if (RegExpTT.QUANTIFIERS.contains(token) || token == RegExpTT.RBRACE || token == RegExpTT.CLASS_END) {
            builder.error("Dangling metacharacter");
        } else {
            builder.error("Pattern expected");
        }
    }

    protected static boolean checkMatches(PsiBuilder builder, IElementType token, String message2) {
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
            return true;
        }
        builder.error(message2);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

