/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.function.Consumer;
import org.intellij.lang.regexp.AsciiUtil;

public class UnicodeCharacterNames {
    public static void iterate(Consumer<String> consumer) {
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, (String)"initNamePool", (Class[])new Class[0]);
            if (initNamePool != null) {
                byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
                int[][] lookup2d = (int[][])ReflectionUtil.getStaticFieldValue(aClass, int[][].class, (String)"lookup");
                if (lookup2d == null) {
                    return;
                }
                for (int[] indexes : lookup2d) {
                    if (indexes == null) continue;
                    for (int index : indexes) {
                        if (index == 0) continue;
                        String name2 = new String(namePool, index >>> 8, index & 0xFF, AsciiUtil.ASCII_CHARSET);
                        consumer.accept(name2);
                    }
                }
            } else {
                Method instance2 = ReflectionUtil.getDeclaredMethod(aClass, (String)"getInstance", (Class[])new Class[0]);
                Field field1 = ReflectionUtil.getDeclaredField(aClass, (String)"strPool");
                Field field2 = ReflectionUtil.getDeclaredField(aClass, (String)"lookup");
                if (instance2 != null && field1 != null && field2 != null) {
                    int[] lookup;
                    Object characterName = instance2.invoke(null, new Object[0]);
                    byte[] namePool = (byte[])field1.get(characterName);
                    for (int index : lookup = (int[])field2.get(characterName)) {
                        if (index == 0) continue;
                        String name3 = new String(namePool, index >>> 8, index & 0xFF, AsciiUtil.ASCII_CHARSET);
                        consumer.accept(name3);
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCodePoint(String name2) {
        if (name2 == null) {
            return -1;
        }
        Method method = ReflectionUtil.getMethod(Character.class, (String)"codePointOf", (Class[])new Class[]{String.class});
        if (method != null) {
            try {
                return (Integer)method.invoke(null, name2);
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, (String)"initNamePool", (Class[])new Class[0]);
            if (initNamePool == null) {
                return -1;
            }
            byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
            name2 = name2.trim().toUpperCase(Locale.ROOT);
            byte[] key2 = name2.getBytes(StandardCharsets.ISO_8859_1);
            int[][] lookup = (int[][])ReflectionUtil.getField(aClass, null, int[][].class, (String)"lookup");
            if (lookup == null) {
                throw new RuntimeException();
            }
            for (int i = 0; i < lookup.length; ++i) {
                int[] indexes = lookup[i];
                if (indexes == null) continue;
                for (int j = 0; j < indexes.length; ++j) {
                    int index = indexes[j];
                    if ((index & 0xFF) != key2.length || !UnicodeCharacterNames.matches(namePool, index >>> 8, key2)) continue;
                    return i << 8 | j;
                }
            }
            return UnicodeCharacterNames.getUnnamedUnicodeCharacterCodePoint(name2);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getUnnamedUnicodeCharacterCodePoint(String name2) {
        int index = name2.lastIndexOf(32);
        if (index != -1) {
            try {
                int c = Integer.parseInt(name2.substring(index + 1, name2.length()), 16);
                if (Character.isValidCodePoint(c) && name2.equals(Character.getName(c))) {
                    return c;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean matches(byte[] bytes, int offset, byte[] key2) {
        if (offset < 0 || offset + key2.length > bytes.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < key2.length; ++i) {
            if (bytes[i + offset] == key2[i]) continue;
            return false;
        }
        return true;
    }
}

