/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.MultiInputFormat;
import com.thaiopensource.relaxng.input.dtd.DtdInputFormat;
import com.thaiopensource.relaxng.input.parse.compact.CompactParseInputFormat;
import com.thaiopensource.relaxng.input.parse.sax.SAXParseInputFormat;
import com.thaiopensource.relaxng.input.xml.XmlInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.output.dtd.DtdOutputFormat;
import com.thaiopensource.relaxng.output.rnc.RncOutputFormat;
import com.thaiopensource.relaxng.output.rng.RngOutputFormat;
import com.thaiopensource.relaxng.output.xsd.XsdOutputFormat;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.util.UriOrFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.IdeaErrorHandler;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IdeaDriver {
    private static final int DEFAULT_LINE_LENGTH = 72;
    private static final int DEFAULT_INDENT = 2;
    private final ConvertSchemaSettings settings;
    private final Project myProject;

    public IdeaDriver(ConvertSchemaSettings settings, Project project2) {
        this.settings = settings;
        this.myProject = project2;
    }

    public void convert(SchemaType inputType, IdeaErrorHandler errorHandler, VirtualFile ... inputFiles) {
        if (inputFiles.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            File outputFile;
            SchemaCollection sc;
            InputFormat inFormat = this.getInputFormat(inputType);
            if (inputFiles.length > 1 && !(inFormat instanceof MultiInputFormat)) {
                throw new IllegalArgumentException();
            }
            VirtualFile inputFile = inputFiles[0];
            SchemaType type2 = this.settings.getOutputType();
            String outputType = type2.toString().toLowerCase();
            ArrayList<String> inputParams = new ArrayList<String>();
            if (inputType != SchemaType.DTD) {
                Charset charset = inputFile.getCharset();
                inputParams.add("encoding=" + charset.name());
            }
            ArrayList<String> outputParams = new ArrayList<String>();
            this.settings.addAdvancedSettings(inputParams, outputParams);
            String input = inputFile.getPath();
            String uri = UriOrFile.toUri((String)input);
            try {
                if (inFormat instanceof MultiInputFormat) {
                    MultiInputFormat format = (MultiInputFormat)inFormat;
                    String[] uris = new String[inputFiles.length];
                    for (int i = 0; i < inputFiles.length; ++i) {
                        uris[i] = UriOrFile.toUri((String)inputFiles[i].getPath());
                    }
                    sc = format.load(uris, ArrayUtil.toStringArray(inputParams), outputType, (ErrorHandler)((Object)errorHandler));
                } else {
                    sc = inFormat.load(uri, ArrayUtil.toStringArray(inputParams), outputType, (ErrorHandler)((Object)errorHandler));
                }
            }
            catch (IOException e) {
                errorHandler.fatalError(new SAXParseException(e.getMessage(), null, uri, -1, -1, e));
                return;
            }
            File destination = new File(this.settings.getOutputDestination());
            if (destination.isDirectory()) {
                String name2 = new File(input).getName();
                int ext = name2.lastIndexOf(46);
                outputFile = new File(destination, (ext > 0 ? name2.substring(0, ext) : name2) + "." + outputType);
            } else {
                outputFile = destination;
            }
            try {
                int indent = this.settings.getIndent();
                int length = this.settings.getLineLength();
                LocalOutputDirectory od = new LocalOutputDirectory(sc.getMainUri(), outputFile, "." + outputType, this.settings.getOutputEncoding(), length > 0 ? length : 72, indent > 0 ? indent : 2){

                    public OutputDirectory.Stream open(String sourceUri, String encoding) throws IOException {
                        String s = this.reference(null, sourceUri);
                        File file2 = new File(outputFile.getParentFile(), s);
                        if (file2.exists()) {
                            String msg = "The file '" + file2.getAbsolutePath() + "' already exists. Overwrite it?";
                            int choice = Messages.showYesNoDialog((Project)IdeaDriver.this.myProject, (String)msg, (String)"Output File Exists", (Icon)Messages.getWarningIcon());
                            if (choice == 0) {
                                return super.open(sourceUri, encoding);
                            }
                            if (choice == 1) {
                                throw new CanceledException();
                            }
                        }
                        return super.open(sourceUri, encoding);
                    }
                };
                OutputFormat of = this.getOutputFormat(this.settings.getOutputType());
                of.output(sc, (OutputDirectory)od, ArrayUtil.toStringArray(outputParams), inputType.toString().toLowerCase(), (ErrorHandler)((Object)errorHandler));
            }
            catch (IOException e) {
                errorHandler.fatalError(new SAXParseException(e.getMessage(), null, UriOrFile.fileToUri((File)outputFile), -1, -1, e));
            }
        }
        catch (CanceledException inFormat) {
        }
        catch (SAXParseException e) {
            errorHandler.error(e);
        }
        catch (MalformedURLException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
        catch (InputFailedException inputFailedException) {
        }
        catch (InvalidParamsException invalidParamsException) {
        }
        catch (OutputFailedException outputFailedException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private OutputFormat getOutputFormat(SchemaType outputType) {
        switch (outputType) {
            case DTD: {
                return new DtdOutputFormat();
            }
            case RNC: {
                return new RncOutputFormat();
            }
            case RNG: {
                return new RngOutputFormat();
            }
            case XSD: {
                return new XsdOutputFormat();
            }
        }
        assert (false) : "Unsupported output type: " + (Object)((Object)outputType);
        return null;
    }

    private InputFormat getInputFormat(SchemaType type2) {
        switch (type2) {
            case DTD: {
                return new DtdInputFormat();
            }
            case RNC: {
                return new CompactParseInputFormat();
            }
            case RNG: {
                return new SAXParseInputFormat();
            }
            case XML: {
                return new XmlInputFormat();
            }
        }
        assert (false) : "Unsupported input type: " + (Object)((Object)type2);
        return null;
    }

    private static class CanceledException
    extends RuntimeException {
        private CanceledException() {
        }
    }
}

