/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SourceInfo;

public final class PsiVisitors {
    public static <RESULT> RESULT visit(@NotNull XSourcePosition position, @NotNull Project project2, @NotNull Visitor<RESULT> visitor) {
        if (position == null) {
            PsiVisitors.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            PsiVisitors.$$$reportNull$$$0(1);
        }
        if (visitor == null) {
            PsiVisitors.$$$reportNull$$$0(2);
        }
        return PsiVisitors.visit(position, project2, visitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <RESULT> RESULT visit(@NotNull XSourcePosition position, @NotNull Project project2, @NotNull Visitor<RESULT> visitor, RESULT defaultResult) {
        if (position == null) {
            PsiVisitors.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            PsiVisitors.$$$reportNull$$$0(4);
        }
        if (visitor == null) {
            PsiVisitors.$$$reportNull$$$0(5);
        }
        AccessToken token = ReadAction.start();
        try {
            int positionOffset;
            PsiFile file2;
            Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
            PsiFile psiFile = file2 = document == null || document.getTextLength() == 0 ? null : PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            if (file2 == null) {
                RESULT RESULT = defaultResult;
                return RESULT;
            }
            int column = position instanceof SourceInfo ? Math.max(((SourceInfo)position).getColumn(), 0) : 0;
            try {
                positionOffset = column == 0 ? DocumentUtil.getFirstNonSpaceCharOffset(document, position.getLine()) : document.getLineStartOffset(position.getLine()) + column;
            }
            catch (IndexOutOfBoundsException ignored) {
                RESULT RESULT = defaultResult;
                token.finish();
                return RESULT;
            }
            PsiElement element = file2.findElementAt(positionOffset);
            RESULT RESULT = element == null ? defaultResult : visitor.visit(position, element, positionOffset, document);
            return RESULT;
        }
        finally {
            token.finish();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "position";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "visitor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/debugger/PsiVisitors";
        objectArray[2] = "visit";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class FilteringPsiRecursiveElementWalkingVisitor
    extends PsiRecursiveElementWalkingVisitor {
        public void visitElement(PsiElement element) {
            if (!(element instanceof ForeignLeafPsiElement) && element.isPhysical()) {
                super.visitElement(element);
            }
        }

        public void visitWhiteSpace(PsiWhiteSpace space) {
        }

        public void visitComment(PsiComment comment) {
        }

        public void visitOuterLanguageElement(OuterLanguageElement element) {
        }
    }

    public static interface Visitor<RESULT> {
        public RESULT visit(@NotNull XSourcePosition var1, @NotNull PsiElement var2, int var3, @NotNull Document var4);
    }
}

