/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

public abstract class RestService
extends HttpRequestHandler {
    protected static final Logger LOG = Logger.getInstance(RestService.class);
    public static final String PREFIX = "api";
    protected final NotNullLazyValue<Gson> gson = new NotNullLazyValue<Gson>(){

        @NotNull
        protected Gson compute() {
            Gson gson2 = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            if (gson2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return gson2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService$1", "compute"));
        }
    };
    private final LoadingCache<InetAddress, AtomicInteger> abuseCounter = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(CacheLoader.from(AtomicInteger::new));
    private final Cache<String, Boolean> trustedOrigins = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterWrite(1L, TimeUnit.DAYS).build();

    @Override
    public final boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            RestService.$$$reportNull$$$0(0);
        }
        if (!this.isMethodSupported(request.method())) {
            return false;
        }
        String uri = request.uri();
        if (this.isPrefixlessAllowed() && RestService.checkPrefix(uri, this.getServiceName())) {
            return true;
        }
        String serviceName = this.getServiceName();
        int minLength = 1 + PREFIX.length() + 1 + serviceName.length();
        if (uri.length() >= minLength && uri.charAt(0) == '/' && uri.regionMatches(true, 1, PREFIX, 0, PREFIX.length()) && uri.regionMatches(true, 2 + PREFIX.length(), serviceName, 0, serviceName.length())) {
            if (uri.length() == minLength) {
                return true;
            }
            char c = uri.charAt(minLength);
            return c == '/' || c == '?';
        }
        return false;
    }

    protected boolean isPrefixlessAllowed() {
        return false;
    }

    @NotNull
    protected abstract String getServiceName();

    protected abstract boolean isMethodSupported(@NotNull HttpMethod var1);

    @Override
    public final boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            RestService.$$$reportNull$$$0(1);
        }
        if (request == null) {
            RestService.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RestService.$$$reportNull$$$0(3);
        }
        try {
            AtomicInteger counter = (AtomicInteger)this.abuseCounter.get((Object)((InetSocketAddress)context.channel().remoteAddress()).getAddress());
            if (counter.incrementAndGet() > Registry.intValue((String)"ide.rest.api.requests.per.minute", (int)30)) {
                Responses.send(Responses.orInSafeMode(HttpResponseStatus.TOO_MANY_REQUESTS, HttpResponseStatus.OK), context.channel(), (HttpRequest)request);
                return true;
            }
            if (!this.isHostTrusted(request)) {
                Responses.send(Responses.orInSafeMode(HttpResponseStatus.FORBIDDEN, HttpResponseStatus.OK), context.channel(), (HttpRequest)request);
                return true;
            }
            String error = this.execute(urlDecoder, request, context);
            if (error != null) {
                Responses.send(HttpResponseStatus.BAD_REQUEST, context.channel(), (HttpRequest)request, error);
            }
        }
        catch (Throwable e) {
            HttpResponseStatus status;
            if (e instanceof MalformedJsonException || e instanceof IllegalStateException && e.getMessage().startsWith("Expected a ")) {
                LOG.warn(e);
                status = HttpResponseStatus.BAD_REQUEST;
            } else {
                LOG.error(e);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            Responses.send(status, context.channel(), (HttpRequest)request, ExceptionUtil.getThrowableText((Throwable)e));
        }
        return true;
    }

    protected boolean isHostTrusted(@NotNull FullHttpRequest request) throws InterruptedException, InvocationTargetException {
        String host;
        if (request == null) {
            RestService.$$$reportNull$$$0(4);
        }
        if (BuiltInWebServerKt.isSignedRequest((HttpRequest)request)) {
            return true;
        }
        String referrer = NettyKt.getOrigin((HttpRequest)request);
        if (referrer == null) {
            referrer = NettyKt.getReferrer((HttpRequest)request);
        }
        try {
            host = StringUtil.nullize(referrer == null ? null : new URI(referrer).getHost());
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        Ref isTrusted = Ref.create();
        if (host != null) {
            if (NetUtils.isLocalhost((String)host)) {
                isTrusted.set((Object)true);
            } else {
                isTrusted.set(this.trustedOrigins.getIfPresent((Object)host));
            }
        }
        if (isTrusted.isNull()) {
            SwingUtilities.invokeAndWait(() -> {
                isTrusted.set((Object)ProjectUtil.showYesNoDialog(IdeBundle.message((String)"warning.use.rest.api", (Object[])new Object[]{this.getServiceName(), ObjectUtils.chooseNotNull((Object)host, (Object)"unknown host")}), "title.use.rest.api"));
                if (host != null) {
                    this.trustedOrigins.put((Object)host, isTrusted.get());
                }
            });
        }
        return (Boolean)isTrusted.get();
    }

    protected static void activateLastFocusedFrame() {
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame instanceof Window) {
            ((Window)frame).toFront();
        }
    }

    @Nullable(value="error text or null if successful")
    public abstract String execute(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    @NotNull
    protected static JsonReader createJsonReader(@NotNull FullHttpRequest request) {
        if (request == null) {
            RestService.$$$reportNull$$$0(5);
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new ByteBufInputStream(request.content()), CharsetToolkit.UTF8_CHARSET));
        reader.setLenient(true);
        JsonReader jsonReader = reader;
        if (jsonReader == null) {
            RestService.$$$reportNull$$$0(6);
        }
        return jsonReader;
    }

    @NotNull
    protected static JsonWriter createJsonWriter(@NotNull OutputStream out) {
        if (out == null) {
            RestService.$$$reportNull$$$0(7);
        }
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(out, CharsetToolkit.UTF8_CHARSET));
        writer.setIndent("  ");
        JsonWriter jsonWriter = writer;
        if (jsonWriter == null) {
            RestService.$$$reportNull$$$0(8);
        }
        return jsonWriter;
    }

    @Nullable
    protected static Project getLastFocusedOrOpenedProject() {
        Project project2;
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project3 = project2 = lastFocusedFrame == null ? null : lastFocusedFrame.getProject();
        if (project2 == null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            return openProjects.length > 0 ? openProjects[0] : null;
        }
        return project2;
    }

    protected static void sendOk(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        if (request == null) {
            RestService.$$$reportNull$$$0(9);
        }
        if (context == null) {
            RestService.$$$reportNull$$$0(10);
        }
        RestService.sendStatus(HttpResponseStatus.OK, HttpUtil.isKeepAlive((HttpMessage)request), context.channel());
    }

    protected static void sendStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel) {
        if (status == null) {
            RestService.$$$reportNull$$$0(11);
        }
        if (channel == null) {
            RestService.$$$reportNull$$$0(12);
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpUtil.setContentLength((HttpMessage)response, (long)0L);
        Responses.addCommonHeaders((HttpResponse)response);
        Responses.addNoCache((HttpResponse)response);
        if (keepAlive) {
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
        }
        response.headers().set("X-Frame-Options", (Object)"Deny");
        Responses.send((HttpResponse)response, channel, !keepAlive);
    }

    protected static void send(@NotNull BufferExposingByteArrayOutputStream byteOut, @NotNull HttpRequest request, @NotNull ChannelHandlerContext context) {
        if (byteOut == null) {
            RestService.$$$reportNull$$$0(13);
        }
        if (request == null) {
            RestService.$$$reportNull$$$0(14);
        }
        if (context == null) {
            RestService.$$$reportNull$$$0(15);
        }
        FullHttpResponse response = Responses.response("application/json", Unpooled.wrappedBuffer((byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size()));
        Responses.addNoCache((HttpResponse)response);
        response.headers().set("X-Frame-Options", (Object)"Deny");
        Responses.send((HttpResponse)response, context.channel(), request);
    }

    @Nullable
    protected static String getStringParameter(@NotNull String name2, @NotNull QueryStringDecoder urlDecoder) {
        if (name2 == null) {
            RestService.$$$reportNull$$$0(16);
        }
        if (urlDecoder == null) {
            RestService.$$$reportNull$$$0(17);
        }
        return (String)ContainerUtil.getLastItem((List)((List)urlDecoder.parameters().get(name2)));
    }

    protected static int getIntParameter(@NotNull String name2, @NotNull QueryStringDecoder urlDecoder) {
        if (name2 == null) {
            RestService.$$$reportNull$$$0(18);
        }
        if (urlDecoder == null) {
            RestService.$$$reportNull$$$0(19);
        }
        return StringUtilRt.parseInt((String)StringUtil.nullize((String)((String)ContainerUtil.getLastItem((List)((List)urlDecoder.parameters().get(name2)))), (boolean)true), (int)-1);
    }

    protected static boolean getBooleanParameter(@NotNull String name2, @NotNull QueryStringDecoder urlDecoder) {
        if (name2 == null) {
            RestService.$$$reportNull$$$0(20);
        }
        if (urlDecoder == null) {
            RestService.$$$reportNull$$$0(21);
        }
        return RestService.getBooleanParameter(name2, urlDecoder, false);
    }

    protected static boolean getBooleanParameter(@NotNull String name2, @NotNull QueryStringDecoder urlDecoder, boolean defaultValue) {
        List values;
        if (name2 == null) {
            RestService.$$$reportNull$$$0(22);
        }
        if (urlDecoder == null) {
            RestService.$$$reportNull$$$0(23);
        }
        if (ContainerUtil.isEmpty((Collection)(values = (List)urlDecoder.parameters().get(name2)))) {
            return defaultValue;
        }
        String value2 = (String)values.get(values.size() - 1);
        return value2.isEmpty() || Boolean.parseBoolean(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlDecoder";
                break;
            }
            case 3: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ide/RestService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteOut";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ide/RestService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsonReader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsonWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isHostTrusted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createJsonReader";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createJsonWriter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sendOk";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sendStatus";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStringParameter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getIntParameter";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

