/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public class JsonUtil {
    private static final String[] REPLACEMENT_CHARS = new String[128];

    public static void escape(@NotNull CharSequence value2, @NotNull StringBuilder sb) {
        if (value2 == null) {
            JsonUtil.$$$reportNull$$$0(0);
        }
        if (sb == null) {
            JsonUtil.$$$reportNull$$$0(1);
        }
        int length = value2.length();
        sb.ensureCapacity(sb.capacity() + length + 2);
        sb.append('\"');
        int last = 0;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value2.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                sb.append(value2, last, i);
            }
            sb.append(replacement);
            last = i + 1;
        }
        if (last < length) {
            sb.append(value2, last, length);
        }
        sb.append('\"');
    }

    public static void escape(@NotNull CharSequence value2, @NotNull ByteBuf buffer) {
        if (value2 == null) {
            JsonUtil.$$$reportNull$$$0(2);
        }
        if (buffer == null) {
            JsonUtil.$$$reportNull$$$0(3);
        }
        int length = value2.length();
        buffer.ensureWritable(length * 2);
        buffer.writeByte(34);
        int last = 0;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value2.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                ByteBufUtilEx.writeUtf8(buffer, value2, last, i);
            }
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)replacement);
            last = i + 1;
        }
        if (last < length) {
            ByteBufUtilEx.writeUtf8(buffer, value2, last, length);
        }
        buffer.writeByte(34);
    }

    @NotNull
    public static <T> List<T> nextList(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            JsonUtil.$$$reportNull$$$0(4);
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List list2 = Collections.emptyList();
            if (list2 == null) {
                JsonUtil.$$$reportNull$$$0(5);
            }
            return list2;
        }
        SmartList list3 = new SmartList();
        JsonUtil.readListBody(reader, list3);
        reader.endArray();
        SmartList smartList = list3;
        if (smartList == null) {
            JsonUtil.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @NotNull
    public static Object[] nextArray(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            JsonUtil.$$$reportNull$$$0(7);
        }
        List list2 = JsonUtil.nextList(reader);
        Object[] objectArray = ArrayUtil.toObjectArray(list2);
        if (objectArray == null) {
            JsonUtil.$$$reportNull$$$0(8);
        }
        return objectArray;
    }

    @NotNull
    public static Map<String, Object> nextObject(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            JsonUtil.$$$reportNull$$$0(9);
        }
        THashMap map = new THashMap();
        reader.beginObject();
        while (reader.hasNext()) {
            map.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        THashMap tHashMap = map;
        if (tHashMap == null) {
            JsonUtil.$$$reportNull$$$0(10);
        }
        return tHashMap;
    }

    @Nullable
    public static Object nextAny(JsonReaderEx reader) {
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                return JsonUtil.nextList(reader);
            }
            case BEGIN_OBJECT: {
                return JsonUtil.nextObject(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public static <T> void readListBody(JsonReaderEx reader, List<T> list2) {
        do {
            list2.add(JsonUtil.nextAny(reader));
        } while (reader.hasNext());
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonUtil.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonUtil.REPLACEMENT_CHARS[34] = "\\\"";
        JsonUtil.REPLACEMENT_CHARS[92] = "\\\\";
        JsonUtil.REPLACEMENT_CHARS[9] = "\\t";
        JsonUtil.REPLACEMENT_CHARS[8] = "\\b";
        JsonUtil.REPLACEMENT_CHARS[10] = "\\n";
        JsonUtil.REPLACEMENT_CHARS[13] = "\\r";
        JsonUtil.REPLACEMENT_CHARS[12] = "\\f";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/JsonUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/JsonUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nextList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nextArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "nextObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nextList";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nextArray";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nextObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

