/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.NettyKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class NettyUtil {
    public static final int MAX_CONTENT_LENGTH = 0x6400000;
    public static final int DEFAULT_CONNECT_ATTEMPT_COUNT = 20;
    public static final int MIN_START_TIME = 100;

    public static void logAndClose(@NotNull Throwable error, @NotNull Logger log, @NotNull Channel channel) {
        if (error == null) {
            NettyUtil.$$$reportNull$$$0(0);
        }
        if (log == null) {
            NettyUtil.$$$reportNull$$$0(1);
        }
        if (channel == null) {
            NettyUtil.$$$reportNull$$$0(2);
        }
        try {
            if (error instanceof ConnectException) {
                log.debug(error);
            } else {
                NettyUtil.log(error, log);
            }
        }
        finally {
            log.info("Channel will be closed due to error");
            channel.close();
        }
    }

    public static void log(@NotNull Throwable throwable, @NotNull Logger log) {
        if (throwable == null) {
            NettyUtil.$$$reportNull$$$0(3);
        }
        if (log == null) {
            NettyUtil.$$$reportNull$$$0(4);
        }
        if (NettyUtil.isAsWarning(throwable)) {
            log.warn(throwable);
        } else {
            log.error(throwable);
        }
    }

    private static boolean isAsWarning(@NotNull Throwable throwable) {
        String message2;
        if (throwable == null) {
            NettyUtil.$$$reportNull$$$0(5);
        }
        if ((message2 = throwable.getMessage()) == null) {
            return false;
        }
        return throwable instanceof IOException && message2.equals("An existing connection was forcibly closed by the remote host") || throwable instanceof ChannelException && message2.startsWith("Failed to bind to: ") || throwable instanceof BindException || message2.startsWith("Connection reset") || message2.equals("Operation timed out") || message2.equals("Connection timed out");
    }

    @NotNull
    public static Bootstrap nioClientBootstrap() {
        Bootstrap bootstrap = NettyUtil.nioClientBootstrap((EventLoopGroup)NettyKt.MultiThreadEventLoopGroup(2));
        if (bootstrap == null) {
            NettyUtil.$$$reportNull$$$0(6);
        }
        return bootstrap;
    }

    @NotNull
    public static Bootstrap nioClientBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup == null) {
            NettyUtil.$$$reportNull$$$0(7);
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        if (bootstrap2 == null) {
            NettyUtil.$$$reportNull$$$0(8);
        }
        return bootstrap2;
    }

    public static void addHttpServerCodec(@NotNull ChannelPipeline pipeline) {
        if (pipeline == null) {
            NettyUtil.$$$reportNull$$$0(9);
        }
        pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder(16384, 16384, 8192));
        pipeline.addLast("httpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(0x6400000));
        if (pipeline.get(ChunkedWriteHandler.class) == null) {
            pipeline.addLast("chunkedWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
        }
        pipeline.addLast("corsHandler", (ChannelHandler)new CorsHandlerDoNotUseOwnLogger(CorsConfigBuilder.forAnyOrigin().shortCircuit().allowCredentials().allowNullOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.PATCH}).allowedRequestHeaders(new String[]{"origin", "accept", "authorization", "content-type", "x-ijt", "x-requested-with"}).build()));
    }

    /*
     * WARNING - void declaration
     */
    public static void awaitQuiescenceOfGlobalEventExecutor(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            NettyUtil.$$$reportNull$$$0(10);
        }
        try {
            void unit;
            GlobalEventExecutor executor = GlobalEventExecutor.INSTANCE;
            executor.awaitInactivity(timeout, (TimeUnit)unit);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/NettyUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLoopGroup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipeline";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/NettyUtil";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nioClientBootstrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logAndClose";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAsWarning";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nioClientBootstrap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addHttpServerCodec";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "awaitQuiescenceOfGlobalEventExecutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CorsHandlerDoNotUseOwnLogger
    extends CorsHandler {
        public CorsHandlerDoNotUseOwnLogger(@NotNull CorsConfig config) {
            if (config == null) {
                CorsHandlerDoNotUseOwnLogger.$$$reportNull$$$0(0);
            }
            super(config);
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            context.fireExceptionCaught(cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/io/NettyUtil$CorsHandlerDoNotUseOwnLogger", "<init>"));
        }
    }
}

