/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc.socket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BinaryRequestHandler;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.socket.SocketClient;

public class RpcBinaryRequestHandler
extends BinaryRequestHandler
implements ExceptionHandler,
ClientListener {
    private static final Logger LOG = Logger.getInstance(RpcBinaryRequestHandler.class);
    private static final UUID ID = UUID.fromString("69957EEB-AFB8-4036-A9A8-00D2D022F9BD");
    private final AtomicNotNullLazyValue<ClientManager> clientManager = new AtomicNotNullLazyValue<ClientManager>(){

        @NotNull
        protected ClientManager compute() {
            ClientManager result2 = new ClientManager(RpcBinaryRequestHandler.this, RpcBinaryRequestHandler.this, null);
            Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
            assert (serverDisposable != null);
            Disposer.register((Disposable)serverDisposable, (Disposable)result2);
            RpcBinaryRequestHandler.this.rpcServer = new JsonRpcServer(result2);
            JsonRpcServerKt.registerFromEp(RpcBinaryRequestHandler.this.rpcServer);
            ClientManager clientManager = result2;
            if (clientManager == null) {
                1.$$$reportNull$$$0(0);
            }
            return clientManager;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler$1", "compute"));
        }
    };
    private JsonRpcServer rpcServer;

    @NotNull
    public JsonRpcServer getRpcServer() {
        this.clientManager.getValue();
        JsonRpcServer jsonRpcServer = this.rpcServer;
        if (jsonRpcServer == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(0);
        }
        return jsonRpcServer;
    }

    @NotNull
    public UUID getId() {
        UUID uUID = ID;
        if (uUID == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(1);
        }
        return uUID;
    }

    @NotNull
    public ChannelHandler getInboundHandler(@NotNull ChannelHandlerContext context) {
        if (context == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(2);
        }
        SocketClient client = new SocketClient(context.channel());
        context.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
        ((ClientManager)this.clientManager.getValue()).addClient(client);
        this.connected(client, null);
        MyDecoder myDecoder = new MyDecoder(client);
        if (myDecoder == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(3);
        }
        return myDecoder;
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e) {
        if (e == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(4);
        }
        LOG.error(e);
    }

    @Override
    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters2) {
        if (client == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void disconnected(@NotNull Client client) {
        if (client == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(6);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRpcServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInboundHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInboundHandler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exceptionCaught";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "connected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "disconnected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDecoder
    extends MessageDecoder {
        private State state;
        private final SocketClient client;

        public MyDecoder(SocketClient client) {
            if (client == null) {
                MyDecoder.$$$reportNull$$$0(0);
            }
            this.state = State.LENGTH;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            if (context == null) {
                MyDecoder.$$$reportNull$$$0(1);
            }
            if (input == null) {
                MyDecoder.$$$reportNull$$$0(2);
            }
            block9: while (true) {
                switch (this.state) {
                    case LENGTH: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 4, context);
                        if (buffer == null) {
                            return;
                        }
                        this.state = State.CONTENT;
                        this.contentLength = buffer.readInt();
                    }
                    case CONTENT: {
                        CharSequence content = this.readChars(input);
                        if (content == null) {
                            return;
                        }
                        try {
                            RpcBinaryRequestHandler.this.rpcServer.messageReceived(this.client, content);
                            continue block9;
                        }
                        catch (Throwable e) {
                            ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).getExceptionHandler().exceptionCaught(e);
                            continue block9;
                        }
                        finally {
                            this.contentLength = 0;
                            this.state = State.LENGTH;
                            continue block9;
                        }
                    }
                }
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext context) throws Exception {
            Client client = (Client)((Object)context.channel().attr(ClientManagerKt.getCLIENT()).get());
            if (client != null) {
                ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).disconnectClient(context.channel(), client, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler$MyDecoder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "messageReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum State {
        LENGTH,
        CONTENT;

    }
}

