/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MultiFileTestCase
extends CodeInsightTestCase {
    protected boolean myDoCompare = true;

    protected void doTest(PerformAction performAction) {
        this.doTest(performAction, this.getTestName(true));
    }

    protected void doTest(PerformAction performAction, boolean lowercaseFirstLetter) {
        this.doTest(performAction, this.getTestName(lowercaseFirstLetter));
    }

    protected void doTest(PerformAction performAction, String testName) {
        try {
            String path = this.getTestDataPath() + this.getTestRoot() + testName;
            String pathBefore = path + "/before";
            VirtualFile rootDir = PsiTestUtil.createTestProjectStructure((Project)this.myProject, (Module)this.myModule, (String)pathBefore, (Collection)myFilesToDelete, (boolean)false);
            this.prepareProject(rootDir);
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            String pathAfter = path + "/after";
            VirtualFile rootAfter = LocalFileSystem.getInstance().findFileByPath(pathAfter.replace(File.separatorChar, '/'));
            performAction.performAction(rootDir, rootAfter);
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> ((PostprocessReformattingAspect)this.myProject.getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting());
            FileDocumentManager.getInstance().saveAllDocuments();
            if (this.myDoCompare) {
                PlatformTestUtil.assertDirectoriesEqual((VirtualFile)rootAfter, (VirtualFile)rootDir);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepareProject(VirtualFile rootDir) {
        PsiTestUtil.addSourceContentToRoots((Module)this.myModule, (VirtualFile)rootDir);
    }

    @Override
    @NotNull
    @NonNls
    protected abstract String getTestRoot();

    protected static interface PerformAction {
        public void performAction(VirtualFile var1, VirtualFile var2) throws Exception;
    }
}

