/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.DefaultLightProjectDescriptor;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class LightCodeInsightFixtureTestCase
extends UsefulTestCase {
    public static final LightProjectDescriptor JAVA_1_4 = new ProjectDescriptor(LanguageLevel.JDK_1_4);
    public static final LightProjectDescriptor JAVA_1_5 = new ProjectDescriptor(LanguageLevel.JDK_1_5);
    public static final LightProjectDescriptor JAVA_1_6 = new ProjectDescriptor(LanguageLevel.JDK_1_6);
    public static final LightProjectDescriptor JAVA_1_7 = new ProjectDescriptor(LanguageLevel.JDK_1_7);
    public static final LightProjectDescriptor JAVA_8 = new ProjectDescriptor(LanguageLevel.JDK_1_8);
    public static final LightProjectDescriptor JAVA_9 = new ProjectDescriptor(LanguageLevel.JDK_1_9);
    public static final LightProjectDescriptor JAVA_10 = new ProjectDescriptor(LanguageLevel.JDK_10);
    public static final LightProjectDescriptor JAVA_LATEST = new ProjectDescriptor(LanguageLevel.HIGHEST){

        @Override
        public Sdk getSdk() {
            return IdeaTestUtil.getMockJdk17();
        }
    };
    protected JavaCodeInsightTestFixture myFixture;
    protected Module myModule;

    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder fixtureBuilder = factory.createLightFixtureBuilder(this.getProjectDescriptor());
        IdeaProjectTestFixture fixture = (IdeaProjectTestFixture)fixtureBuilder.getFixture();
        this.myFixture = JavaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, (TempDirTestFixture)new LightTempDirTestFixtureImpl(true));
        this.myFixture.setUp();
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myModule = this.myFixture.getModule();
        LanguageLevelProjectExtension.getInstance((Project)this.getProject()).setLanguageLevel(LanguageLevel.JDK_1_6);
    }

    protected void tearDown() throws Exception {
        try {
            this.myFixture.tearDown();
        }
        finally {
            this.myFixture = null;
            this.myModule = null;
            super.tearDown();
        }
    }

    protected String getBasePath() {
        return "";
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        LightProjectDescriptor lightProjectDescriptor = JAVA_LATEST;
        if (lightProjectDescriptor == null) {
            LightCodeInsightFixtureTestCase.$$$reportNull$$$0(0);
        }
        return lightProjectDescriptor;
    }

    protected String getTestDataPath() {
        String communityPath = PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/');
        String path = communityPath + this.getBasePath();
        return new File(path).exists() ? path : communityPath + "/../" + this.getBasePath();
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiFile getFile() {
        return this.myFixture.getFile();
    }

    protected Editor getEditor() {
        return this.myFixture.getEditor();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    public PsiElementFactory getElementFactory() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
    }

    protected PsiFile createLightFile(FileType fileType, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("a." + fileType.getDefaultExtension(), fileType, (CharSequence)text);
    }

    public PsiFile createLightFile(String fileName, Language language, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, language, (CharSequence)text, false, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/LightCodeInsightFixtureTestCase", "getProjectDescriptor"));
    }

    protected static class ProjectDescriptor
    extends DefaultLightProjectDescriptor {
        private final LanguageLevel myLanguageLevel;

        public ProjectDescriptor(@NotNull LanguageLevel languageLevel) {
            if (languageLevel == null) {
                ProjectDescriptor.$$$reportNull$$$0(0);
            }
            this.myLanguageLevel = languageLevel;
        }

        @Override
        public Sdk getSdk() {
            return IdeaTestUtil.getMockJdk(this.myLanguageLevel.toJavaVersion());
        }

        @Override
        public void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
            if (module == null) {
                ProjectDescriptor.$$$reportNull$$$0(1);
            }
            if (model == null) {
                ProjectDescriptor.$$$reportNull$$$0(2);
            }
            if (contentEntry == null) {
                ProjectDescriptor.$$$reportNull$$$0(3);
            }
            ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLanguageLevel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentEntry";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/fixtures/LightCodeInsightFixtureTestCase$ProjectDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureModule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

