/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.distribution.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.internal.DefaultDistributionContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.TextUtil;

@Incubating
public class DistributionPlugin
implements Plugin<ProjectInternal> {
    public static final String MAIN_DISTRIBUTION_NAME = "main";
    public static final String TASK_INSTALL_NAME = "installDist";
    private static final String DISTRIBUTION_GROUP = "distribution";
    private static final String TASK_DIST_ZIP_NAME = "distZip";
    private static final String TASK_DIST_TAR_NAME = "distTar";
    private static final String TASK_ASSEMBLE_NAME = "assembleDist";
    private final Instantiator instantiator;
    private final FileOperations fileOperations;

    @Inject
    public DistributionPlugin(Instantiator instantiator, FileOperations fileOperations) {
        this.instantiator = instantiator;
        this.fileOperations = fileOperations;
    }

    @Override
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(BasePlugin.class);
        DistributionContainer distributions = project.getExtensions().create(DistributionContainer.class, "distributions", DefaultDistributionContainer.class, Distribution.class, this.instantiator, this.fileOperations);
        distributions.all(new Action<Distribution>(){

            @Override
            public void execute(final Distribution dist) {
                ((IConventionAware)((Object)dist)).getConventionMapping().map("baseName", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return dist.getName().equals(DistributionPlugin.MAIN_DISTRIBUTION_NAME) ? project.getName() : String.format("%s-%s", project.getName(), dist.getName());
                    }
                });
                dist.getContents().from("src/" + dist.getName() + "/dist");
                String zipTaskName = DistributionPlugin.MAIN_DISTRIBUTION_NAME.equals(dist.getName()) ? DistributionPlugin.TASK_DIST_ZIP_NAME : dist.getName() + "DistZip";
                Task zipTask = DistributionPlugin.this.configureArchiveTask(project, zipTaskName, dist, Zip.class);
                String tarTaskName = DistributionPlugin.MAIN_DISTRIBUTION_NAME.equals(dist.getName()) ? DistributionPlugin.TASK_DIST_TAR_NAME : dist.getName() + "DistTar";
                Task tarTask = DistributionPlugin.this.configureArchiveTask(project, tarTaskName, dist, Tar.class);
                DistributionPlugin.this.addAssembleTask(project, dist, new Task[]{zipTask, tarTask});
                DistributionPlugin.this.addInstallTask(project, dist);
            }
        });
        distributions.create(MAIN_DISTRIBUTION_NAME);
    }

    private <T extends AbstractArchiveTask> Task configureArchiveTask(Project project, String taskName, final Distribution distribution, Class<T> type) {
        final AbstractArchiveTask archiveTask = (AbstractArchiveTask)project.getTasks().create(taskName, type);
        archiveTask.setDescription("Bundles the project as a distribution.");
        archiveTask.setGroup(DISTRIBUTION_GROUP);
        archiveTask.getConventionMapping().map("baseName", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (distribution.getBaseName() == null || distribution.getBaseName().equals("")) {
                    throw new GradleException("Distribution baseName must not be null or empty! Check your configuration of the distribution plugin.");
                }
                return distribution.getBaseName();
            }
        });
        Callable<String> baseDir = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return TextUtil.minus(archiveTask.getArchiveName(), "." + archiveTask.getExtension());
            }
        };
        CopySpec childSpec = project.copySpec();
        childSpec.into(baseDir);
        childSpec.with(distribution.getContents());
        archiveTask.with(childSpec);
        ArchivePublishArtifact archiveArtifact = new ArchivePublishArtifact(archiveTask);
        project.getExtensions().getByType(DefaultArtifactPublicationSet.class).addCandidate(archiveArtifact);
        return archiveTask;
    }

    private void addInstallTask(final Project project, final Distribution distribution) {
        String taskName = TASK_INSTALL_NAME;
        if (!MAIN_DISTRIBUTION_NAME.equals(distribution.getName())) {
            taskName = "install" + StringGroovyMethods.capitalize((String)distribution.getName()) + "Dist";
        }
        Sync installTask = project.getTasks().create(taskName, Sync.class);
        installTask.setDescription("Installs the project as a distribution as-is.");
        installTask.setGroup(DISTRIBUTION_GROUP);
        installTask.with(distribution.getContents());
        installTask.into(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.file("" + project.getBuildDir() + "/install/" + distribution.getBaseName());
            }
        });
    }

    private void addAssembleTask(Project project, Distribution distribution, Task ... tasks) {
        String taskName = TASK_ASSEMBLE_NAME;
        if (!MAIN_DISTRIBUTION_NAME.equals(distribution.getName())) {
            taskName = "assemble" + StringGroovyMethods.capitalize((String)distribution.getName()) + "Dist";
        }
        Task assembleTask = project.getTasks().create(taskName);
        assembleTask.setDescription("Assembles the " + distribution.getName() + " distributions");
        assembleTask.setGroup(DISTRIBUTION_GROUP);
        assembleTask.dependsOn(tasks);
    }
}

