/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;

class ComponentMetaDataResolveState {
    private final DefaultBuildableModuleComponentMetaDataResolveResult resolveResult = new DefaultBuildableModuleComponentMetaDataResolveResult();
    private final VersionedComponentChooser versionedComponentChooser;
    private final ComponentOverrideMetadata componentOverrideMetadata;
    private final ModuleComponentIdentifier componentIdentifier;
    final ModuleComponentRepository repository;
    private boolean searchedLocally;
    private boolean searchedRemotely;

    public ComponentMetaDataResolveState(ModuleComponentIdentifier componentIdentifier, ComponentOverrideMetadata componentOverrideMetadata, ModuleComponentRepository repository, VersionedComponentChooser versionedComponentChooser) {
        this.componentOverrideMetadata = componentOverrideMetadata;
        this.componentIdentifier = componentIdentifier;
        this.repository = repository;
        this.versionedComponentChooser = versionedComponentChooser;
    }

    BuildableModuleComponentMetaDataResolveResult resolve() {
        if (!this.searchedLocally) {
            this.searchedLocally = true;
            this.process(this.repository.getLocalAccess());
            if (this.resolveResult.hasResult()) {
                if (this.resolveResult.isAuthoritative()) {
                    this.searchedRemotely = true;
                }
                return this.resolveResult;
            }
        }
        if (!this.searchedRemotely) {
            this.searchedRemotely = true;
            this.process(this.repository.getRemoteAccess());
            return this.resolveResult;
        }
        throw new IllegalStateException();
    }

    protected void process(ModuleComponentRepositoryAccess moduleAccess) {
        moduleAccess.resolveComponentMetaData(this.componentIdentifier, this.componentOverrideMetadata, this.resolveResult);
        if (this.resolveResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved && this.versionedComponentChooser.isRejectedComponent(this.componentIdentifier, new MetadataProvider(this.resolveResult))) {
            this.resolveResult.missing();
        }
    }

    protected void applyTo(ResourceAwareResolveResult result) {
        this.resolveResult.applyTo(result);
    }

    public boolean canMakeFurtherAttempts() {
        return !this.searchedRemotely;
    }
}

