/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifacts;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;

class InMemoryArtifactsCache {
    private final Map<ComponentArtifactIdentifier, File> artifacts = Maps.newConcurrentMap();
    private final Map<ComponentIdentifier, ComponentArtifacts> componentArtifacts = Maps.newConcurrentMap();
    private final Map<TypedArtifactsKey, Set<ComponentArtifactMetadata>> typedArtifacts = Maps.newConcurrentMap();

    InMemoryArtifactsCache() {
    }

    public boolean supplyArtifact(ComponentArtifactIdentifier id, BuildableArtifactResolveResult result) {
        File fromCache = this.artifacts.get(id);
        if (fromCache != null) {
            result.resolved(fromCache);
            return true;
        }
        return false;
    }

    public void newArtifact(ComponentArtifactIdentifier id, BuildableArtifactResolveResult result) {
        if (result.isSuccessful()) {
            this.artifacts.put(id, result.getResult());
        }
    }

    public boolean supplyArtifacts(ComponentIdentifier component, ArtifactType type, BuildableArtifactSetResolveResult result) {
        Set<ComponentArtifactMetadata> artifacts = this.typedArtifacts.get(new TypedArtifactsKey(component, type));
        if (artifacts != null) {
            result.resolved(artifacts);
            return true;
        }
        return false;
    }

    public void newArtifacts(ComponentIdentifier component, ArtifactType type, BuildableArtifactSetResolveResult result) {
        if (result.isSuccessful()) {
            this.typedArtifacts.put(new TypedArtifactsKey(component, type), (Set<ComponentArtifactMetadata>)ImmutableSet.copyOf((Collection)((Collection)result.getResult())));
        }
    }

    public boolean supplyArtifacts(ComponentIdentifier component, BuildableComponentArtifactsResolveResult result) {
        ComponentArtifacts artifacts = this.componentArtifacts.get(component);
        if (artifacts != null) {
            result.resolved(artifacts);
            return true;
        }
        return false;
    }

    public void newArtifacts(ComponentIdentifier component, BuildableComponentArtifactsResolveResult result) {
        if (result.isSuccessful()) {
            this.componentArtifacts.put(component, (ComponentArtifacts)result.getResult());
        }
    }

    private static class TypedArtifactsKey {
        private final ComponentIdentifier componentId;
        private final ArtifactType type;

        public TypedArtifactsKey(ComponentIdentifier componentId, ArtifactType type) {
            this.componentId = componentId;
            this.type = type;
        }

        public boolean equals(Object obj) {
            TypedArtifactsKey other = (TypedArtifactsKey)obj;
            return this.componentId.equals(other.componentId) && this.type.equals((Object)other.type);
        }

        public int hashCode() {
            return this.componentId.hashCode() ^ this.type.hashCode();
        }
    }
}

