/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.IvyDependencyDescriptorFactory;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.CollectionUtils;

public abstract class AbstractIvyDependencyDescriptorFactory
implements IvyDependencyDescriptorFactory {
    private ExcludeRuleConverter excludeRuleConverter;

    public AbstractIvyDependencyDescriptorFactory(ExcludeRuleConverter excludeRuleConverter) {
        this.excludeRuleConverter = excludeRuleConverter;
    }

    private String getExtension(DependencyArtifact artifact) {
        return artifact.getExtension() != null ? artifact.getExtension() : artifact.getType();
    }

    protected List<Exclude> convertExcludeRules(final String configuration, Set<ExcludeRule> excludeRules) {
        return CollectionUtils.collect(excludeRules, new Transformer<Exclude, ExcludeRule>(){

            @Override
            public Exclude transform(ExcludeRule excludeRule) {
                return AbstractIvyDependencyDescriptorFactory.this.excludeRuleConverter.convertExcludeRule(configuration, excludeRule);
            }
        });
    }

    protected Set<IvyArtifactName> convertArtifacts(Set<DependencyArtifact> dependencyArtifacts) {
        return CollectionUtils.collect(dependencyArtifacts, new Transformer<IvyArtifactName, DependencyArtifact>(){

            @Override
            public IvyArtifactName transform(DependencyArtifact dependencyArtifact) {
                return new DefaultIvyArtifactName(dependencyArtifact.getName(), dependencyArtifact.getType(), AbstractIvyDependencyDescriptorFactory.this.getExtension(dependencyArtifact), dependencyArtifact.getClassifier());
            }
        });
    }
}

