/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ArtifactExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.IvyPatternMatcherExcludeRuleSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleIdExcludeSpec;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;

final class ImmutableModuleExclusionSet
implements Set<AbstractModuleExclusion> {
    private final Set<AbstractModuleExclusion> delegate;
    final AbstractModuleExclusion[] elements;
    private final int hashCode;
    private ImmutableSet<ModuleIdentifier> excludedModules;
    private ImmutableList<AbstractModuleExclusion> otherExcludes;
    private ImmutableList<AbstractModuleExclusion> artifactExcludes;

    ImmutableModuleExclusionSet(ImmutableSet<AbstractModuleExclusion> delegate) {
        this.delegate = delegate;
        this.elements = (AbstractModuleExclusion[])delegate.toArray((Object[])new AbstractModuleExclusion[0]);
        this.hashCode = delegate.hashCode();
    }

    private synchronized void precomputeCaches() {
        if (this.excludedModules != null) {
            return;
        }
        ImmutableSet.Builder modules = ImmutableSet.builder();
        ImmutableList.Builder other = ImmutableList.builder();
        ImmutableList.Builder artifacts = ImmutableList.builder();
        for (AbstractModuleExclusion exclusion : this.delegate) {
            if (exclusion instanceof ModuleIdExcludeSpec) {
                modules.add((Object)((ModuleIdExcludeSpec)exclusion).moduleId);
                continue;
            }
            other.add((Object)exclusion);
            if (!(exclusion instanceof ArtifactExcludeSpec) && !(exclusion instanceof IvyPatternMatcherExcludeRuleSpec)) continue;
            artifacts.add((Object)exclusion);
        }
        this.excludedModules = modules.build();
        this.otherExcludes = other.build();
        this.artifactExcludes = artifacts.build();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<AbstractModuleExclusion> iterator() {
        return Iterators.forArray((Object[])this.elements);
    }

    boolean excludesModule(ModuleIdentifier id) {
        this.precomputeCaches();
        if (this.excludedModules.contains((Object)id)) {
            return true;
        }
        for (AbstractModuleExclusion excludeSpec : this.otherExcludes) {
            if (!excludeSpec.excludeModule(id)) continue;
            return true;
        }
        return false;
    }

    boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        this.precomputeCaches();
        for (AbstractModuleExclusion excludeSpec : this.artifactExcludes) {
            if (!excludeSpec.excludeArtifact(module, artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.elements;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return (Object[])Cast.uncheckedCast(this.elements);
    }

    @Override
    public boolean add(AbstractModuleExclusion abstractModuleExclusion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends AbstractModuleExclusion> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableModuleExclusionSet that = (ImmutableModuleExclusionSet)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

