/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.OptionalDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.OptionalDependenciesState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingOptionalDependencies;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultOptionalDependenciesHandler
implements OptionalDependenciesHandler {
    private final OptionalDependenciesState optionalDependencies = new OptionalDependenciesState();
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final ComponentSelectorConverter componentSelectorConverter;

    public DefaultOptionalDependenciesHandler(ComponentSelectorConverter componentSelectorConverter, DependencySubstitutionApplicator dependencySubstitutionApplicator) {
        this.componentSelectorConverter = componentSelectorConverter;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
    }

    @Override
    public OptionalDependenciesHandler.Visitor start(boolean isOptionalConfiguration) {
        return new DefaultVisitor(isOptionalConfiguration);
    }

    public class DefaultVisitor
    implements OptionalDependenciesHandler.Visitor {
        private final boolean isOptionalConfiguration;
        private List<PendingOptionalDependencies> noLongerOptional;

        public DefaultVisitor(boolean isOptionalConfiguration) {
            this.isOptionalConfiguration = isOptionalConfiguration;
        }

        @Override
        public boolean maybeAddAsOptionalDependency(NodeState node, DependencyState dependencyState) {
            ModuleIdentifier key = this.lookupModuleIdentifier(dependencyState);
            PendingOptionalDependencies pendingOptionalDependencies = DefaultOptionalDependenciesHandler.this.optionalDependencies.getPendingOptionalDependencies(key);
            boolean pending = pendingOptionalDependencies.isPending();
            if (dependencyState.getDependencyMetadata().isOptional() && !this.isOptionalConfiguration && pending) {
                pendingOptionalDependencies.addNode(node);
                return true;
            }
            if (pending) {
                if (this.noLongerOptional == null) {
                    this.noLongerOptional = Lists.newLinkedList();
                }
                this.noLongerOptional.add(pendingOptionalDependencies);
            }
            DefaultOptionalDependenciesHandler.this.optionalDependencies.notOptional(key);
            return false;
        }

        private ModuleIdentifier lookupModuleIdentifier(DependencyState dependencyState) {
            DependencySubstitutionApplicator.SubstitutionResult substitutionResult = DefaultOptionalDependenciesHandler.this.dependencySubstitutionApplicator.apply(dependencyState.getDependencyMetadata());
            DependencySubstitutionInternal details = substitutionResult.getResult();
            if (details != null && details.isUpdated()) {
                return DefaultOptionalDependenciesHandler.this.componentSelectorConverter.getModule(details.getTarget());
            }
            return dependencyState.getModuleIdentifier();
        }

        @Override
        public void complete() {
            if (this.noLongerOptional != null) {
                for (PendingOptionalDependencies optionalDependencies : this.noLongerOptional) {
                    optionalDependencies.turnIntoHardDependencies();
                }
                this.noLongerOptional = null;
            }
        }
    }
}

