/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.VariantMetadataAdapter;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class ComponentMetadataDetailsAdapter
implements ComponentMetadataDetails {
    private final MutableModuleComponentResolveMetadata metadata;
    private final Instantiator instantiator;
    private final NotationParser<Object, DependencyMetadata> dependencyMetadataNotationParser;

    public ComponentMetadataDetailsAdapter(MutableModuleComponentResolveMetadata metadata, Instantiator instantiator, NotationParser<Object, DependencyMetadata> dependencyMetadataNotationParser) {
        this.metadata = metadata;
        this.instantiator = instantiator;
        this.dependencyMetadataNotationParser = dependencyMetadataNotationParser;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.metadata.getId();
    }

    @Override
    public boolean isChanging() {
        return this.metadata.isChanging();
    }

    @Override
    public String getStatus() {
        return this.metadata.getStatus();
    }

    @Override
    public List<String> getStatusScheme() {
        return this.metadata.getStatusScheme();
    }

    @Override
    public void setChanging(boolean changing) {
        this.metadata.setChanging(changing);
    }

    @Override
    public void setStatus(String status) {
        this.metadata.setStatus(status);
    }

    @Override
    public void setStatusScheme(List<String> statusScheme) {
        this.metadata.setStatusScheme(statusScheme);
    }

    @Override
    public void withVariant(String name, Action<VariantMetadata> action) {
        this.assertVariantExists(name);
        action.execute(this.instantiator.newInstance(VariantMetadataAdapter.class, name, this.metadata, this.instantiator, this.dependencyMetadataNotationParser));
    }

    private void assertVariantExists(String name) {
        if (!this.metadata.definesVariant(name)) {
            throw new GradleException("Variant " + name + " is not declared for " + this.metadata.getId());
        }
    }
}

