/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolverDescriptorParseContext;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionPatternVisitor;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.model.IvyModulePublishMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DefaultModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.BuildableTypedResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.local.ByteArrayReadableContent;
import org.gradle.internal.resource.local.FileReadableContent;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalResourceResolver<T extends ModuleComponentResolveMetadata, S extends MutableModuleComponentResolveMetadata>
implements ModuleVersionPublisher,
ConfiguredModuleComponentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceResolver.class);
    private final String name;
    private final List<ResourcePattern> ivyPatterns = new ArrayList<ResourcePattern>();
    private final List<ResourcePattern> artifactPatterns = new ArrayList<ResourcePattern>();
    private ComponentResolvers componentResolvers;
    private final ExternalResourceRepository repository;
    private final boolean local;
    private final CacheAwareExternalResourceAccessor cachingResourceAccessor;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final FileResourceRepository fileResourceRepository;
    private final VersionLister versionLister;
    private String id;
    private ExternalResourceArtifactResolver cachedArtifactResolver;

    protected ExternalResourceResolver(String name, boolean local, ExternalResourceRepository repository, CacheAwareExternalResourceAccessor cachingResourceAccessor, VersionLister versionLister, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileResourceRepository fileResourceRepository) {
        this.name = name;
        this.local = local;
        this.cachingResourceAccessor = cachingResourceAccessor;
        this.versionLister = versionLister;
        this.repository = repository;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.fileResourceRepository = fileResourceRepository;
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        this.id = this.generateId(this);
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract Class<T> getSupportedMetadataType();

    @Override
    public boolean isDynamicResolveMode() {
        return false;
    }

    public void setComponentResolvers(ComponentResolvers resolver) {
        this.componentResolvers = resolver;
    }

    protected ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        throw new UnsupportedOperationException();
    }

    private void doListModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
        ModuleIdentifier module = this.moduleIdentifierFactory.module(dependency.getSelector().getGroup(), dependency.getSelector().getModule());
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        VersionPatternVisitor visitor = this.versionLister.newVisitor(module, versions, result);
        IvyArtifactName metaDataArtifact = this.getMetaDataArtifactName(dependency.getSelector().getModule());
        this.listVersionsForAllPatterns(this.ivyPatterns, metaDataArtifact, visitor);
        for (IvyArtifactName otherArtifact : this.getDependencyArtifactNames(dependency.getSelector().getModule(), dependency.getArtifacts())) {
            this.listVersionsForAllPatterns(this.artifactPatterns, otherArtifact, visitor);
        }
        result.listed(versions);
    }

    private void listVersionsForAllPatterns(List<ResourcePattern> patternList, IvyArtifactName ivyArtifactName, VersionPatternVisitor visitor) {
        for (ResourcePattern resourcePattern : patternList) {
            visitor.visit(resourcePattern, ivyArtifactName);
        }
    }

    protected void doResolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult result) {
        this.resolveStaticDependency(moduleComponentIdentifier, prescribedMetaData, result, this.createArtifactResolver());
    }

    protected final void resolveStaticDependency(ModuleComponentIdentifier moduleVersionIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult result, ExternalResourceArtifactResolver artifactResolver) {
        S metaDataArtifactMetaData = this.parseMetaDataFromArtifact(moduleVersionIdentifier, artifactResolver, result);
        if (metaDataArtifactMetaData != null) {
            LOGGER.debug("Metadata file found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)this.getName());
            metaDataArtifactMetaData.setSource(artifactResolver.getSource());
            result.resolved(metaDataArtifactMetaData.asImmutable());
            return;
        }
        S metaDataFromDefaultArtifact = this.createMetaDataFromDefaultArtifact(moduleVersionIdentifier, prescribedMetaData, artifactResolver, result);
        if (metaDataFromDefaultArtifact != null) {
            LOGGER.debug("Found artifact but no meta-data for module '{}' in repository '{}', using default meta-data.", (Object)moduleVersionIdentifier, (Object)this.getName());
            metaDataFromDefaultArtifact.setSource(artifactResolver.getSource());
            result.resolved(metaDataFromDefaultArtifact.asImmutable());
            return;
        }
        LOGGER.debug("No meta-data file or artifact found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)this.getName());
        result.missing();
    }

    @Nullable
    protected S parseMetaDataFromArtifact(ModuleComponentIdentifier moduleComponentIdentifier, ExternalResourceArtifactResolver artifactResolver, ResourceAwareResolveResult result) {
        ModuleDescriptorArtifactMetadata artifact = this.getMetaDataArtifactFor(moduleComponentIdentifier);
        LocallyAvailableExternalResource metaDataResource = artifactResolver.resolveArtifact(artifact, result);
        if (metaDataResource == null) {
            return null;
        }
        ExternalResourceResolverDescriptorParseContext context = new ExternalResourceResolverDescriptorParseContext(this.componentResolvers, this.fileResourceRepository, this.moduleIdentifierFactory);
        return this.parseMetaDataFromResource(moduleComponentIdentifier, metaDataResource, context);
    }

    private S createMetaDataFromDefaultArtifact(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata overrideMetadata, ExternalResourceArtifactResolver artifactResolver, ResourceAwareResolveResult result) {
        Set<IvyArtifactName> artifacts = overrideMetadata.getArtifacts();
        for (IvyArtifactName artifact : this.getDependencyArtifactNames(moduleComponentIdentifier.getModule(), artifacts)) {
            if (!artifactResolver.artifactExists(new DefaultModuleComponentArtifactMetadata(moduleComponentIdentifier, artifact), result)) continue;
            return this.createMissingComponentMetadata(moduleComponentIdentifier);
        }
        return null;
    }

    protected abstract S createMissingComponentMetadata(ModuleComponentIdentifier var1);

    protected abstract S parseMetaDataFromResource(ModuleComponentIdentifier var1, LocallyAvailableExternalResource var2, DescriptorParseContext var3);

    private Set<IvyArtifactName> getDependencyArtifactNames(String moduleName, Set<IvyArtifactName> artifacts) {
        LinkedHashSet artifactSet = Sets.newLinkedHashSet();
        artifactSet.addAll(artifacts);
        if (artifactSet.isEmpty()) {
            artifactSet.add(new DefaultIvyArtifactName(moduleName, "jar", "jar"));
        }
        return artifactSet;
    }

    protected void checkMetadataConsistency(ModuleComponentIdentifier expectedId, MutableModuleComponentResolveMetadata metadata) throws MetaDataParseException {
        this.checkModuleIdentifier(expectedId, metadata.getId());
    }

    private void checkModuleIdentifier(ModuleComponentIdentifier expectedId, ModuleVersionIdentifier actualId) {
        ArrayList<String> errors = new ArrayList<String>();
        this.checkEquals("group", expectedId.getGroup(), actualId.getGroup(), errors);
        this.checkEquals("module name", expectedId.getModule(), actualId.getName(), errors);
        this.checkEquals("version", expectedId.getVersion(), actualId.getVersion(), errors);
        if (errors.size() > 0) {
            throw new MetaDataParseException(String.format("inconsistent module metadata found. Descriptor: %s Errors: %s", actualId, this.joinLines(errors)));
        }
    }

    private String joinLines(List<String> lines) {
        return Joiner.on((String)SystemProperties.getInstance().getLineSeparator()).join(lines);
    }

    private void checkEquals(String label, String expected, String actual, List<String> errors) {
        if (!expected.equals(actual)) {
            errors.add("bad " + label + ": expected='" + expected + "' found='" + actual + "'");
        }
    }

    protected abstract boolean isMetaDataArtifact(ArtifactType var1);

    protected Set<ModuleComponentArtifactMetadata> findOptionalArtifacts(ModuleComponentResolveMetadata module, String type, String classifier) {
        ModuleComponentArtifactMetadata artifact = module.artifact(type, "jar", classifier);
        if (this.createArtifactResolver(module.getSource()).artifactExists(artifact, new DefaultResourceAwareResolveResult())) {
            return ImmutableSet.of((Object)artifact);
        }
        return Collections.emptySet();
    }

    private ModuleDescriptorArtifactMetadata getMetaDataArtifactFor(ModuleComponentIdentifier moduleComponentIdentifier) {
        IvyArtifactName ivyArtifactName = this.getMetaDataArtifactName(moduleComponentIdentifier.getModule());
        DefaultModuleComponentArtifactMetadata defaultModuleComponentArtifactMetadata = new DefaultModuleComponentArtifactMetadata(moduleComponentIdentifier, ivyArtifactName);
        return new DefaultModuleDescriptorArtifactMetadata(defaultModuleComponentArtifactMetadata);
    }

    protected abstract IvyArtifactName getMetaDataArtifactName(String var1);

    protected ExternalResourceArtifactResolver createArtifactResolver() {
        ExternalResourceArtifactResolver artifactResolver;
        if (this.cachedArtifactResolver != null) {
            return this.cachedArtifactResolver;
        }
        this.cachedArtifactResolver = artifactResolver = this.createArtifactResolver(this.ivyPatterns, this.artifactPatterns);
        return artifactResolver;
    }

    protected ExternalResourceArtifactResolver createArtifactResolver(List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns) {
        return new DefaultExternalResourceArtifactResolver(this.repository, this.locallyAvailableResourceFinder, ivyPatterns, artifactPatterns, this.artifactFileStore, this.cachingResourceAccessor);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver(ModuleSource moduleSource) {
        return this.createArtifactResolver();
    }

    @Override
    public void publish(IvyModulePublishMetadata moduleVersion) {
        for (IvyModuleArtifactPublishMetadata artifact : moduleVersion.getArtifacts()) {
            this.publish(new DefaultModuleComponentArtifactMetadata(artifact.getId()), artifact.getFile());
        }
    }

    private void publish(ModuleComponentArtifactMetadata artifact, File src) {
        ResourcePattern destinationPattern;
        if ("ivy".equals(artifact.getName().getType()) && !this.ivyPatterns.isEmpty()) {
            destinationPattern = this.ivyPatterns.get(0);
        } else if (!this.artifactPatterns.isEmpty()) {
            destinationPattern = this.artifactPatterns.get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        ExternalResourceName destination = destinationPattern.getLocation(artifact);
        this.put(src, destination);
        LOGGER.info("Published {} to {}", (Object)artifact, (Object)destination);
    }

    private void put(File src, ExternalResourceName destination) {
        this.repository.withProgressLogging().resource(destination).put(new FileReadableContent(src));
        this.putChecksum(src, destination);
    }

    private void putChecksum(File source, ExternalResourceName destination) {
        byte[] checksumFile = this.createChecksumFile(source, "SHA1", 40);
        ExternalResourceName checksumDestination = destination.append(".sha1");
        this.repository.resource(checksumDestination).put(new ByteArrayReadableContent(checksumFile));
    }

    private byte[] createChecksumFile(File src, String algorithm, int checksumLength) {
        HashValue hash = HashUtil.createHash(src, algorithm);
        String formattedHashString = hash.asZeroPaddedHexString(checksumLength);
        try {
            return formattedHashString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    protected void addIvyPattern(ResourcePattern pattern) {
        this.invalidateCaches();
        this.ivyPatterns.add(pattern);
    }

    private void invalidateCaches() {
        this.id = null;
        this.cachedArtifactResolver = null;
    }

    protected void addArtifactPattern(ResourcePattern pattern) {
        this.invalidateCaches();
        this.artifactPatterns.add(pattern);
    }

    public List<String> getIvyPatterns() {
        return CollectionUtils.collect(this.ivyPatterns, new Transformer<String, ResourcePattern>(){

            @Override
            public String transform(ResourcePattern original) {
                return original.getPattern();
            }
        });
    }

    public List<String> getArtifactPatterns() {
        return CollectionUtils.collect(this.artifactPatterns, new Transformer<String, ResourcePattern>(){

            @Override
            public String transform(ResourcePattern original) {
                return original.getPattern();
            }
        });
    }

    protected void setIvyPatterns(Iterable<? extends ResourcePattern> patterns) {
        this.invalidateCaches();
        this.ivyPatterns.clear();
        CollectionUtils.addAll(this.ivyPatterns, patterns);
    }

    protected void setArtifactPatterns(List<ResourcePattern> patterns) {
        this.invalidateCaches();
        this.artifactPatterns.clear();
        CollectionUtils.addAll(this.artifactPatterns, patterns);
    }

    private String generateId(ExternalResourceResolver resolver) {
        DefaultBuildCacheHasher cacheHasher = new DefaultBuildCacheHasher();
        cacheHasher.putString(this.getClass().getName());
        cacheHasher.putInt(resolver.ivyPatterns.size());
        for (ResourcePattern ivyPattern : this.ivyPatterns) {
            cacheHasher.putString(ivyPattern.getPattern());
        }
        cacheHasher.putInt(this.artifactPatterns.size());
        for (ResourcePattern artifactPattern : this.artifactPatterns) {
            cacheHasher.putString(artifactPattern.getPattern());
        }
        this.appendId(cacheHasher);
        return cacheHasher.hash().toString();
    }

    protected abstract void appendId(BuildCacheHasher var1);

    private static class NoOpResourceAwareResolveResult
    implements ResourceAwareResolveResult {
        private static final NoOpResourceAwareResolveResult INSTANCE = new NoOpResourceAwareResolveResult();

        private NoOpResourceAwareResolveResult() {
        }

        @Override
        public List<String> getAttempted() {
            return Collections.emptyList();
        }

        @Override
        public void attempted(String locationDescription) {
        }

        @Override
        public void attempted(ExternalResourceName location) {
        }

        @Override
        public void applyTo(ResourceAwareResolveResult target) {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class RemoteRepositoryAccess
    extends AbstractRepositoryAccess {
        protected RemoteRepositoryAccess() {
        }

        public String toString() {
            return "remote > " + ExternalResourceResolver.this.toString();
        }

        @Override
        public final void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            ExternalResourceResolver.this.doListModuleVersions(dependency, result);
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            ExternalResourceResolver.this.doResolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            super.resolveArtifactsWithType(component, artifactType, result);
            this.checkArtifactsResolved(component, (Object)artifactType, result);
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            super.resolveArtifacts(component, result);
            this.checkArtifactsResolved(component, "artifacts", result);
        }

        private void checkArtifactsResolved(ComponentResolveMetadata component, Object context, BuildableTypedResolveResult<?, ? super ArtifactResolveException> result) {
            if (!result.hasResult()) {
                result.failed(new ArtifactResolveException(component.getComponentId(), String.format("Cannot locate %s for '%s' in repository '%s'", context, component, ExternalResourceResolver.this.name)));
            }
        }

        @Override
        protected final void resolveMetaDataArtifacts(T module, BuildableArtifactSetResolveResult result) {
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            try {
                ExternalResourceArtifactResolver resolver = ExternalResourceResolver.this.createArtifactResolver(moduleSource);
                ModuleComponentArtifactMetadata moduleArtifact = (ModuleComponentArtifactMetadata)artifact;
                LocallyAvailableExternalResource artifactResource = resolver.resolveArtifact(moduleArtifact, result);
                if (artifactResource == null) {
                    result.notFound(artifact.getId());
                } else {
                    result.resolved(artifactResource.getFile());
                }
            }
            catch (Throwable e) {
                result.failed(new ArtifactResolveException(artifact.getId(), e));
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            if (ExternalResourceResolver.this.local) {
                ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(moduleComponentIdentifier);
                if (ExternalResourceResolver.this.createArtifactResolver().artifactExists(artifact, NoOpResourceAwareResolveResult.INSTANCE)) {
                    return MetadataFetchingCost.FAST;
                }
                return MetadataFetchingCost.CHEAP;
            }
            return MetadataFetchingCost.EXPENSIVE;
        }
    }

    protected abstract class LocalRepositoryAccess
    extends AbstractRepositoryAccess {
        protected LocalRepositoryAccess() {
        }

        public String toString() {
            return "local > " + ExternalResourceResolver.this.toString();
        }

        @Override
        public final void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
        }

        @Override
        protected final void resolveMetaDataArtifacts(T module, BuildableArtifactSetResolveResult result) {
            ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(module.getComponentId());
            result.resolved(Collections.singleton(artifact));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return MetadataFetchingCost.CHEAP;
        }
    }

    protected abstract class AbstractRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        protected AbstractRepositoryAccess() {
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            ModuleComponentResolveMetadata moduleMetaData = (ModuleComponentResolveMetadata)ExternalResourceResolver.this.getSupportedMetadataType().cast(component);
            if (artifactType == ArtifactType.JAVADOC) {
                this.resolveJavadocArtifacts(moduleMetaData, result);
            } else if (artifactType == ArtifactType.SOURCES) {
                this.resolveSourceArtifacts(moduleMetaData, result);
            } else if (ExternalResourceResolver.this.isMetaDataArtifact(artifactType)) {
                this.resolveMetaDataArtifacts(moduleMetaData, result);
            }
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            ModuleComponentResolveMetadata moduleMetaData = (ModuleComponentResolveMetadata)ExternalResourceResolver.this.getSupportedMetadataType().cast(component);
            this.resolveModuleArtifacts(moduleMetaData, result);
        }

        protected abstract void resolveModuleArtifacts(T var1, BuildableComponentArtifactsResolveResult var2);

        protected abstract void resolveMetaDataArtifacts(T var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveJavadocArtifacts(T var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveSourceArtifacts(T var1, BuildableArtifactSetResolveResult var2);
    }
}

