/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.internal.impldep.com.google.common.collect.AbstractIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTaskStateChanges
implements TaskStateChanges {
    private final TaskStateChanges delegate;
    private final List<TaskStateChange> cache = new ArrayList<TaskStateChange>();
    private final int maxCachedChanges;
    private Iterator<TaskStateChange> delegateIterator;
    boolean overrun;

    public CachingTaskStateChanges(int maxCachedChanges, TaskStateChanges delegate) {
        this.maxCachedChanges = maxCachedChanges;
        this.delegate = delegate;
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.delegateIterator == null || this.overrun) {
            this.reset();
        }
        return new AbstractIterator<TaskStateChange>(){
            final Iterator<TaskStateChange> cacheIterator;
            {
                this.cacheIterator = new ArrayList(CachingTaskStateChanges.this.cache).iterator();
            }

            protected TaskStateChange computeNext() {
                if (this.cacheIterator.hasNext()) {
                    return this.cacheIterator.next();
                }
                if (CachingTaskStateChanges.this.delegateIterator.hasNext()) {
                    TaskStateChange next = (TaskStateChange)CachingTaskStateChanges.this.delegateIterator.next();
                    CachingTaskStateChanges.this.maybeCache(next);
                    return next;
                }
                return (TaskStateChange)this.endOfData();
            }
        };
    }

    private void maybeCache(TaskStateChange next) {
        if (this.overrun) {
            return;
        }
        if (this.cache.size() < this.maxCachedChanges) {
            this.cache.add(next);
        } else {
            this.overrun = true;
        }
    }

    private void reset() {
        this.cache.clear();
        this.delegateIterator = this.delegate.iterator();
        this.overrun = false;
    }
}

