/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskTypeTaskStateChanges
extends SimpleTaskStateChanges {
    private final TaskExecution previousExecution;
    private final TaskExecution currentExecution;
    private final TaskInternal task;

    public TaskTypeTaskStateChanges(@Nullable TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task) {
        this.previousExecution = previousExecution;
        this.currentExecution = currentExecution;
        this.task = task;
    }

    @Override
    protected void addAllChanges(List<TaskStateChange> changes) {
        ImplementationSnapshot prevImplementation = this.previousExecution.getTaskImplementation();
        ImplementationSnapshot taskImplementation = this.currentExecution.getTaskImplementation();
        if (!taskImplementation.getTypeName().equals(prevImplementation.getTypeName())) {
            changes.add(new DescriptiveChange("Task '%s' has changed type from '%s' to '%s'.", this.task.getIdentityPath(), prevImplementation.getTypeName(), taskImplementation.getTypeName()));
            return;
        }
        if (taskImplementation.hasUnknownClassLoader()) {
            changes.add(new DescriptiveChange("Task '%s' was loaded with an unknown classloader", this.task.getIdentityPath()));
            return;
        }
        if (prevImplementation.hasUnknownClassLoader()) {
            changes.add(new DescriptiveChange("Task '%s' was loaded with an unknown classloader during the previous execution", this.task.getIdentityPath()));
            return;
        }
        if (!taskImplementation.getClassLoaderHash().equals(prevImplementation.getClassLoaderHash())) {
            changes.add(new DescriptiveChange("Task '%s' class path has changed from %s to %s.", this.task.getIdentityPath(), prevImplementation.getClassLoaderHash(), taskImplementation.getClassLoaderHash()));
            return;
        }
        ImmutableList<ImplementationSnapshot> taskActionImplementations = this.currentExecution.getTaskActionImplementations();
        if (TaskTypeTaskStateChanges.hasAnyUnknownClassLoader(taskActionImplementations)) {
            changes.add(new DescriptiveChange("Task '%s' has an additional action that was loaded with an unknown classloader", this.task.getIdentityPath()));
            return;
        }
        if (TaskTypeTaskStateChanges.hasAnyUnknownClassLoader(this.previousExecution.getTaskActionImplementations())) {
            changes.add(new DescriptiveChange("Task '%s' had an additional action that was loaded with an unknown classloader during the previous execution", this.task.getIdentityPath()));
            return;
        }
        if (!taskActionImplementations.equals(this.previousExecution.getTaskActionImplementations())) {
            changes.add(new DescriptiveChange("Task '%s' has additional actions that have changed", this.task.getIdentityPath()));
        }
    }

    private static boolean hasAnyUnknownClassLoader(Iterable<ImplementationSnapshot> implementations) {
        for (ImplementationSnapshot implementation : implementations) {
            if (!implementation.hasUnknownClassLoader()) continue;
            return true;
        }
        return false;
    }
}

