/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.DirectoryFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotVisitor;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.FileTreeSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.VisitingFileCollectionSnapshotBuilder;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.internal.serialize.SerializerRegistry;

public abstract class AbstractFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final StringInterner stringInterner;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileSystemSnapshotter fileSystemSnapshotter;

    public AbstractFileCollectionSnapshotter(StringInterner stringInterner, DirectoryFileTreeFactory directoryFileTreeFactory, FileSystemSnapshotter fileSystemSnapshotter) {
        this.stringInterner = stringInterner;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
    }

    public void registerSerializers(SerializerRegistry registry) {
        registry.register(DefaultFileCollectionSnapshot.class, new DefaultFileCollectionSnapshot.SerializerImpl(this.stringInterner));
    }

    public FileCollectionSnapshot snapshot(FileCollection input, VisitingFileCollectionSnapshotBuilder builder) {
        FileCollectionInternal fileCollection = (FileCollectionInternal)input;
        FileCollectionVisitorImpl visitor = new FileCollectionVisitorImpl(builder);
        fileCollection.visitRootElements(visitor);
        return builder.build();
    }

    protected StringInterner getStringInterner() {
        return this.stringInterner;
    }

    private class FileCollectionVisitorImpl
    implements FileCollectionVisitor {
        private final FileSnapshotVisitor fileSnapshotVisitor;

        FileCollectionVisitorImpl(FileSnapshotVisitor fileSnapshotVisitor) {
            this.fileSnapshotVisitor = fileSnapshotVisitor;
        }

        public void visitCollection(FileCollectionInternal fileCollection) {
            block5: for (File file : fileCollection) {
                FileSnapshot fileSnapshot = AbstractFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshotSelf(file);
                switch (fileSnapshot.getType()) {
                    case Missing: {
                        this.fileSnapshotVisitor.visitMissingFileSnapshot((MissingFileSnapshot)fileSnapshot);
                        continue block5;
                    }
                    case RegularFile: {
                        this.fileSnapshotVisitor.visitFileSnapshot((RegularFileSnapshot)fileSnapshot);
                        continue block5;
                    }
                    case Directory: {
                        this.fileSnapshotVisitor.visitDirectorySnapshot((DirectoryFileSnapshot)fileSnapshot);
                        this.visitDirectoryTree(AbstractFileCollectionSnapshotter.this.directoryFileTreeFactory.create(file));
                        continue block5;
                    }
                }
                throw new AssertionError();
            }
        }

        public void visitTree(FileTreeInternal fileTree) {
            List<FileSnapshot> descendants = AbstractFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshotTree(fileTree);
            this.fileSnapshotVisitor.visitFileTreeSnapshot(descendants);
        }

        public void visitDirectoryTree(DirectoryFileTree directoryTree) {
            FileTreeSnapshot treeSnapshot = AbstractFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshotDirectoryTree(directoryTree);
            Collection<FileSnapshot> descendants = treeSnapshot.getDescendants();
            this.fileSnapshotVisitor.visitFileTreeSnapshot(descendants);
        }
    }
}

