/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotMapSerializer;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCollectionSnapshot
implements FileCollectionSnapshot {
    private final Map<String, NormalizedFileSnapshot> snapshots;
    private final TaskFilePropertyCompareStrategy compareStrategy;
    private final boolean pathIsAbsolute;
    private final Factory<List<File>> cachedElementsFactory = Factories.softReferenceCache(new Factory<List<File>>(){

        @Override
        public List<File> create() {
            return DefaultFileCollectionSnapshot.this.doGetElements();
        }
    });
    private final Factory<List<File>> cachedFilesFactory = Factories.softReferenceCache(new Factory<List<File>>(){

        @Override
        public List<File> create() {
            return DefaultFileCollectionSnapshot.this.doGetFiles();
        }
    });
    private HashCode hashCode;

    public DefaultFileCollectionSnapshot(Map<String, NormalizedFileSnapshot> snapshots, TaskFilePropertyCompareStrategy compareStrategy, boolean pathIsAbsolute) {
        this(snapshots, null, compareStrategy, pathIsAbsolute);
    }

    DefaultFileCollectionSnapshot(Map<String, NormalizedFileSnapshot> snapshots, @Nullable HashCode hashCode, TaskFilePropertyCompareStrategy compareStrategy, boolean pathIsAbsolute) {
        this.snapshots = snapshots;
        this.hashCode = hashCode;
        this.compareStrategy = compareStrategy;
        this.pathIsAbsolute = pathIsAbsolute;
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public Map<String, FileContentSnapshot> getContentSnapshots() {
        return Maps.transformValues(this.snapshots, (Function)new Function<NormalizedFileSnapshot, FileContentSnapshot>(){

            public FileContentSnapshot apply(NormalizedFileSnapshot normalizedSnapshot) {
                return normalizedSnapshot.getSnapshot();
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.snapshots.isEmpty();
    }

    @Override
    public Iterator<TaskStateChange> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, String fileType, boolean includeAdded) {
        if (includeAdded && this.hashCode != null && this.getHash().equals(oldSnapshot.getHash())) {
            return Iterators.emptyIterator();
        }
        return this.compareStrategy.iterateContentChangesSince(this.snapshots, oldSnapshot.getSnapshots(), fileType, this.pathIsAbsolute, includeAdded);
    }

    @Override
    public HashCode getHash() {
        if (this.hashCode == null) {
            DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
            this.compareStrategy.appendToHasher(hasher, this.snapshots.values());
            this.hashCode = hasher.hash();
        }
        return this.hashCode;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putHash(this.getHash());
    }

    public List<File> getElements() {
        return this.cachedElementsFactory.create();
    }

    private List<File> doGetElements() {
        ArrayList files = Lists.newArrayListWithCapacity((int)this.snapshots.size());
        for (String name : this.snapshots.keySet()) {
            files.add(new File(name));
        }
        return files;
    }

    public List<File> getFiles() {
        return this.cachedFilesFactory.create();
    }

    public String toString() {
        return (Object)((Object)this.compareStrategy) + (this.pathIsAbsolute ? " with absolute paths" : "") + ": " + this.snapshots;
    }

    private List<File> doGetFiles() {
        ArrayList files = Lists.newArrayList();
        for (Map.Entry<String, NormalizedFileSnapshot> entry : this.snapshots.entrySet()) {
            if (entry.getValue().getSnapshot().getType() != FileType.RegularFile) continue;
            files.add(new File(entry.getKey()));
        }
        return files;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializerImpl
    extends AbstractSerializer<DefaultFileCollectionSnapshot> {
        private final SnapshotMapSerializer snapshotMapSerializer;
        private final HashCodeSerializer hashCodeSerializer;

        public SerializerImpl(StringInterner stringInterner) {
            this.snapshotMapSerializer = new SnapshotMapSerializer(stringInterner);
            this.hashCodeSerializer = new HashCodeSerializer();
        }

        @Override
        public DefaultFileCollectionSnapshot read(Decoder decoder) throws Exception {
            TaskFilePropertyCompareStrategy compareStrategy = TaskFilePropertyCompareStrategy.values()[decoder.readSmallInt()];
            boolean hasHash = decoder.readBoolean();
            HashCode hash = hasHash ? this.hashCodeSerializer.read(decoder) : null;
            Object snapshots = this.snapshotMapSerializer.read(decoder);
            boolean pathIsUnique = decoder.readBoolean();
            return new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)snapshots, hash, compareStrategy, pathIsUnique);
        }

        @Override
        public void write(Encoder encoder, DefaultFileCollectionSnapshot value) throws Exception {
            encoder.writeSmallInt(value.compareStrategy.ordinal());
            boolean hasHash = value.hashCode != null;
            encoder.writeBoolean(hasHash);
            if (hasHash) {
                this.hashCodeSerializer.write(encoder, value.getHash());
            }
            this.snapshotMapSerializer.write(encoder, value.snapshots);
            encoder.writeBoolean(value.pathIsAbsolute);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            SerializerImpl rhs = (SerializerImpl)obj;
            return Objects.equal((Object)this.snapshotMapSerializer, (Object)rhs.snapshotMapSerializer);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.snapshotMapSerializer});
        }
    }
}

